class PBFieldNote
  attr_accessor :fieldeffect
  attr_accessor :text
  attr_accessor :elaboration
  attr_accessor :cogwheeltext

  def initialize(fieldeffect, text, elaboration = "", cogwheeltext = "")
    @fieldeffect = fieldeffect
    @text = text
    @elaboration = elaboration
    @cogwheeltext = cogwheeltext
  end
end

def feToStringName(fieldeffect,dig1,dig2=nil)
  return PBMoves.getName(FIELDEFFECTS.dig(fieldeffect, dig1)) if dig1 == :NATUREMOVES
  if dig2.nil?
    return FIELDEFFECTS.dig(fieldeffect, dig1).map {|id| PBMoves.getName(id) }.sort.join(", ")
  else
    return FIELDEFFECTS.dig(fieldeffect, dig1, dig2).map {|id| PBMoves.getName(id)}.sort.join(", ")
  end
end
#up by x1.5                <icon=fieldUp> <c=green>x1.5</c>
#down by 0.5               <icon=fieldDown> <c=red>x0.5</c>
#green                     <c=green></c>
#red                       <c=red></c>         (actually crimson bc funny) (hi ily)
#orange                    <c=orange></c>
#field general             <icon=field>
#field change              <icon=fieldChange>
#field up                  <icon=fieldUp>
#field down                <icon=fieldDown>
#field plus                <icon=fieldPlus>
#type boosted              PBFieldNote.new(1,"<icon=fieldElectric> attacks <icon=fieldUp> <c=green>x1.5</c> when . . .","...when attacker is grounded."),
#attacks boosted           PBFieldNote.new(1,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",FIELDEFFECTS.dig(PBFields::ELECTRICT, :MOVEDAMAGEBOOST, 1.5)),
#attacks weakened          PBFieldNote.new(1,"Certain attacks <icon=fieldDown> <c=red>x0.5</c> . . . ",FIELDEFFECTS.dig(PBFields::ELECTRICT, :MOVEDAMAGEBOOST, 0.5)),
def pbCompileFieldNotes
  all_field_notes = [
  #Electric Field
    PBFieldNote.new(1,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::ELECTRICT, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(1,"Grounded Pokémon <icon=fieldChange> <icon=fieldNoSleep> "),
    PBFieldNote.new(1,"<c=green>Created</c> by . . .","Electric Surge, Electric Terrain (5 turns), Stoked Sparksurfer, Ion Deluge (3 turns), Plasma Fists (3 turns), when the attacker does not hold an Everstone."),
    PBFieldNote.new(1,"<icon=fieldElectric> attacks <icon=fieldUp> <c=green>x1.5</c> when . . .","...when attacker is grounded."),
    PBFieldNote.new(1,"Certain attacks <icon=fieldPlus> <icon=fieldElectric> . . . ",feToStringName(PBFields::ELECTRICT,:MOVETYPEMOD,PBTypes::ELECTRIC)),
    PBFieldNote.new(1,"Focus Punch will always <c=red>fail</c> "),
    PBFieldNote.new(1,"Certain stat moves effect <icon=fieldUp> . . . ","Charge, Eerie Impulse"),
    PBFieldNote.new(1,"Magnet Rise lasts <c=green>8</c> turns"),
    PBFieldNote.new(1,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::ELECTRICT,:MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(1,"Certain attacks <icon=fieldUp> <c=green>x2</c> . . . ",feToStringName(PBFields::ELECTRICT, :MOVEDAMAGEBOOST, 2.0)),
    PBFieldNote.new(1,"<c=green>Activates</c> Surge Surfer"),
    PBFieldNote.new(1,"<c=green>Activates</c> Motor Drive . . .", "...each turn."),
    PBFieldNote.new(1,"<c=red>Disables</c> Comatose"),
    PBFieldNote.new(1,"Slow Start timer <icon=fieldChange> <c=green>x2</c> per turn"),
    PBFieldNote.new(1,"Galvanize power boost <icon=fieldChange> <c=green>x1.5</c> "),
    PBFieldNote.new(1,"Wild Charge <icon=fieldChange> <c=green>no recoil</c> "),
    PBFieldNote.new(1,"<c=red>Destroyed</c> by these moves . . .", feToStringName(PBFields::ELECTRICT, :FIELDCHANGE, 0)),
    PBFieldNote.new(1,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::ELECTRICT, :NATUREMOVES)}"),
    PBFieldNote.new(1,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::ELECTRICT, :MIMICRY))}> "),
    PBFieldNote.new(1,"Secret Power <icon=fieldChange> <icon=fieldParalyze> "),
    PBFieldNote.new(1,"Activates <c=orange>Elemental Seed</c>. . .","Boosts Speed and applies Charge to the user."),
  #Grassy Terrain
    PBFieldNote.new(2,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::GRASSYT, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(2,"Pokémon <icon=fieldPlus> <c=green>1/16 HP</c> when . . .", "...when grounded"),
    PBFieldNote.new(2,"<c=green>Created</c> by . . .","Grassy Surge, Grassy Terrain (5 turns), Bloom Doom when not in Forest or Flower Garden fields (3 turns)"),
    PBFieldNote.new(2,"<icon=fieldGrass> attacks <icon=fieldUp> <c=green>x1.5</c> when . . .","...when attacker is grounded."),
    PBFieldNote.new(2,"<icon=fieldFire> attacks <icon=fieldUp> <c=green>x1.5</c> when . . .","...when target is grounded."),
    PBFieldNote.new(2,"<c=green>Activates</c> Grass Pelt"),
    PBFieldNote.new(2,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::GRASSYT, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(2,"Certain attacks <icon=fieldDown> <c=red>x0.5</c> . . . ",feToStringName(PBFields::GRASSYT, :MOVEDAMAGEBOOST, 0.5)),
    PBFieldNote.new(2,"Grass Whistle's Accuracy <icon=fieldChange> <c=green>80</c> "),
    PBFieldNote.new(2,"Certain stat moves' effect <icon=fieldUp> . . .","Coil, Growth"),
    PBFieldNote.new(2,"Nature's Madness damage <icon=fieldChange> <c=green>75 % HP</c> "),
    PBFieldNote.new(2,"Floral Healing heals <c=green>100 %</c> Max HP"),
    PBFieldNote.new(2,"Becomes <c=orange>Burning Field</c> when . . .", "...when #{feToStringName(PBFields::GRASSYT, :FIELDCHANGE, PBFields::BURNINGF)} is used in the absence of Rain or Water Sport."),
    PBFieldNote.new(2,"Becomes <c=orange>Corrosive Field</c> when . . .", "...when #{feToStringName(PBFields::GRASSYT, :FIELDCHANGE, PBFields::CORROSIVEF)} is used."),
    PBFieldNote.new(2,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::GRASSYT, :NATUREMOVES)}"),
    PBFieldNote.new(2,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::GRASSYT, :MIMICRY))}> "),
    PBFieldNote.new(2,"Secret Power <icon=fieldChange> <icon=fieldSleep> "),
    PBFieldNote.new(2,"Activates <c=orange>Elemental Seed</c>. . .","Boosts Defense and applies Ingrain to the user."),
  #Misty Terrain
    PBFieldNote.new(3,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::MISTYT, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(3,"Grounded Pokémon <c=red>immune</c> to status"),
    PBFieldNote.new(3,"<c=green>Created</c> by . . .","Misty Surge, Misty Terrain (5 turns), Mist (3 turns), when the attacker does not hold an Everstone."),
    PBFieldNote.new(3,"<icon=fieldDragon> attacks <icon=fieldDown> <c=red>x0.5</c> "),
    PBFieldNote.new(3,"<icon=fieldFairy> Pokémon's Sp.Def <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(3,"<c=green>Activates</c> Marvel Scale"),
    PBFieldNote.new(3,"Dry Skin slowly <c=green>restores HP</c> "),
    PBFieldNote.new(3,"Pixilate power boost <icon=fieldChange> <c=green>x1.5</c> "),
    PBFieldNote.new(3,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::MISTYT, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(3,"Certain attacks <icon=fieldDown> <c=red>x0.5</c> . . . ",feToStringName(PBFields::MISTYT, :MOVEDAMAGEBOOST, 0.5)),
    PBFieldNote.new(3,"Soul Heart also <c=green>boosts</c> Sp.Def"),
    PBFieldNote.new(3,"Certain stat moves' effect <icon=fieldUp> . . . ","Aromatic Mist, Cosmic Power"),
    PBFieldNote.new(3,"Sweet Scent <c=red>lowers</c> Def & Sp.Def"),
    PBFieldNote.new(3,"Wish recovery <icon=fieldChange> <c=green>75 % HP</c> "),
    PBFieldNote.new(3,"Aqua Ring recovery <icon=fieldChange> <c=green>1/8 HP</c> "),
    PBFieldNote.new(3,"<c=red>Destroyed</c> by these moves . . .", feToStringName(PBFields::MISTYT, :FIELDCHANGE, 0)),
    PBFieldNote.new(3,"Becomes <c=orange>Corrosive Mist</c> when . . .", "...when Acid Downpour is used, or when one of these moves is used twice: Clear Smog, Poison Gas, Smog"),
    PBFieldNote.new(3,"<c=red>Prevents</c> use of these moves . . .","Explosion, Mind Blown, Self-Destruct"),
    PBFieldNote.new(3,"<c=green>Activates</c> Water Compaction when . . .","...when Pokémon is sent out."),
    PBFieldNote.new(3,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::MISTYT, :NATUREMOVES)}"),
    PBFieldNote.new(3,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::MISTYT, :MIMICRY))}> "),
    PBFieldNote.new(3,"Secret Power <icon=fieldChange> <c=red>lowers</c> Sp.Atk"),
    PBFieldNote.new(3,"Activates <c=orange>Elemental Seed</c>. . .","Boosts Sp.Def and applies Wish to the user."),
  #Dark Crystal Cavern
    PBFieldNote.new(4,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::DARKCRYSTALC, :INTROMESSAGE)}\"</c> "),
    #PBFieldNote.new(4,"<icon=fieldDark> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(4,"Certain attacks <icon=fieldUp> <c=green>x2</c> . . . ",feToStringName(PBFields::DARKCRYSTALC, :MOVEDAMAGEBOOST, 2.0)),
    PBFieldNote.new(4,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::DARKCRYSTALC, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(4,"Certain attacks <icon=fieldDown> <c=red>x0.5</c> . . . ",feToStringName(PBFields::DARKCRYSTALC, :MOVEDAMAGEBOOST, 0.5)),
    PBFieldNote.new(4,"<icon=fieldDark> Pokémon's defenses <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(4,"<icon=fieldGhost> Pokémon's defenses <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(4,"Certain stat moves' effect <icon=fieldUp> . . . ","Flash"),
    PBFieldNote.new(4,"Dark Void's Accuracy <icon=fieldChange> <c=green>100</c> "),
    PBFieldNote.new(4,"Moonlight recovery <icon=fieldChange> <c=green>75 % HP</c> "),
    PBFieldNote.new(4,"Synthesis/Morning Sun <icon=fieldChange> <c=red>25 % HP</c> "),
    PBFieldNote.new(4,"<c=red>Prevents</c> these moves . . .","Solar Beam, Solar Blade"),
    PBFieldNote.new(4,"Becomes <c=orange>Crystal Cavern</c> when . . .","...when the weather is Sunny, for as long as the sun lasts."),
    PBFieldNote.new(4,"Becomes a <c=orange>Cave</c> when . . .", "...when #{feToStringName(PBFields::DARKCRYSTALC, :FIELDCHANGE, PBFields::CAVE)} is used."),
    PBFieldNote.new(4,"<c=green>Enables</c> Aurora Veil"),
    PBFieldNote.new(4,"Prism Armor <c=green>lowers damage</c>x0.5"),
    PBFieldNote.new(4,"Shadow Shield <c=green>reduces</c> damage","Shadow Shield reduces damage of super effective hits by 0.75"),
    PBFieldNote.new(4,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::DARKCRYSTALC, :NATUREMOVES)}"),
    PBFieldNote.new(4,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::DARKCRYSTALC, :MIMICRY))}> "),
    PBFieldNote.new(4,"Secret Power <icon=fieldChange> <c=red>lowers</c> Accuracy"),
    PBFieldNote.new(4,"Activates <c=orange>Magical Seed</c>. . .","Boosts Sp.Def and applies Magic Coat to the user."),
  #Chess Field
    PBFieldNote.new(5,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::CHESSB, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(5,"Pokémon are assigned as <c=orange>Pieces</c> . . .","...based on specific criteria. A Pokémon can only be one Piece."),
    PBFieldNote.new(5,"<c=orange>Pawn</c> - Sent out first turn of battle","Overrides all other roles except Queen."),
    PBFieldNote.new(5,"<c=orange>Rook</c> - Highest stat is Def or Sp.Def "),
    PBFieldNote.new(5,"<c=orange>Bishop</c> - Highest stat is Atk or Sp.Atk"),
    PBFieldNote.new(5,"<c=orange>Knight</c> - Highest stat is Speed "),
    PBFieldNote.new(5,"<c=orange>Queen</c> - Final slot in party","Overrides all roles. One per team."),
    PBFieldNote.new(5,"<c=orange>King</c> - Holds King's Rock or lowest HP","Overrides Knight, Bishop and Rook. One per team."),
    PBFieldNote.new(5,"<c=orange>Pieces</c> gain the following effects:"),
    PBFieldNote.new(5,"<c=orange>Pawn</c> - <icon=fieldPlus> Focus Sash's effect"),
    PBFieldNote.new(5,"<c=orange>Rook</c> - Def and Sp.Def <icon=fieldUp> "),
    PBFieldNote.new(5,"<c=orange>Bishop</c> - Attack and Sp.Atk <icon=fieldUp> "),
    PBFieldNote.new(5,"<c=orange>Knight</c> - Deals <c=green>3x</c> damage to <c=orange>Queens</c> and", "...and deals 1.25x damage when using a move in double battle that targets both opponents."),
    PBFieldNote.new(5,"<c=orange>Queen</c> - Def, Sp.Def, and damage <icon=fieldUp> "),
    PBFieldNote.new(5,"<c=orange>King</c> - All attacks <icon=fieldPlus> 1 Priority"),
    PBFieldNote.new(5,"Certain moves <icon=fieldChange> <c=orange>Chess Attacks</c> ","#{PBFields::CHESSMOVES.map {|id| PBMoves.getName(id)}.sort.join(", ")}"),
    PBFieldNote.new(5,"<c=orange>Chess Attacks</c> <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(5,"<c=orange>Chess Attacks</c> <icon=fieldPlus> <icon=fieldRock> "),
    PBFieldNote.new(5,"<c=orange>Chess Attacks</c> <icon=fieldUp> <c=green>x2</c> when . . .", "...when the target has Oblivious, Simple, Unaware, Klutz, or is confused."),
    PBFieldNote.new(5,"<c=orange>Chess Attacks</c> <icon=fieldDown> <c=red>x0.5</c> when . . .", "...when the target has Adaptability, Synchronize, Anticipation or Telepathy."),
    PBFieldNote.new(5,"Trick Room lasts <c=green>8</c> turns . . ."),
    PBFieldNote.new(5,"Queenly Majesty damage <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(5,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . .", feToStringName(PBFields::CHESSB, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(5,"Certain stat moves' effect <icon=fieldUp> . . . ","Calm Mind, Nasty Plot"),
    PBFieldNote.new(5,"Certain attacks <icon=fieldPlus> <c=green>protection</c> . . .","King's Shield additionally protects from non-damaging moves."),
    PBFieldNote.new(5,"King's Shield <icon=fieldPlus> <c=green>lowers</c> Sp.Atk"),
    PBFieldNote.new(5,"<c=red>Destroyed</c> by these moves . . .",feToStringName(PBFields::CHESSB, :FIELDCHANGE, 0)),
    PBFieldNote.new(5,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::CHESSB, :NATUREMOVES)}"),
    PBFieldNote.new(5,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::CHESSB, :MIMICRY))}> "),
    PBFieldNote.new(5,"Secret Power <icon=fieldChange> <c=red>lowers</c> Defense"),
    PBFieldNote.new(5,"Activates <c=orange>Synthetic Seed</c>. . .","Boosts Sp.Atk and applies Magic Coat to the user."),
  #Big Top Arena
    PBFieldNote.new(6,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::BIGTOPA, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(6,"Certain moves <icon=fieldChange> <c=orange>Striker Moves</c> ","All physical Fighting moves, #{PBFields::STRIKERMOVES.map {|id| PBMoves.getName(id)}.sort.join(", ")}"),
    PBFieldNote.new(6,"<c=orange>Striker Moves</c> <icon=fieldChange> random damage","Damage rolls set multipliers between x0.5 and x3"),
    PBFieldNote.new(6,"<c=orange>Striker Moves</c> roll <c=green>high</c> when . . .", "...when the attacker has one of these abilities: Sheer Force, Guts, Huge Power, Pure Power"),
    PBFieldNote.new(6,"<c=orange>Striker Moves</c> roll base on Atk stat","A boosted Attack stat increases the chance of high rolls. Lowered Attack decreases the chance of high rolls, regardless of ability."),
    PBFieldNote.new(6,"Acrobatics <icon=fieldChange> always <c=green>full</c> damage"),
    PBFieldNote.new(6,"Sound-based moves <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(6,"Pay Day BP <icon=fieldUp> <c=green>x2</c> and payout <icon=fieldUp> "),
    PBFieldNote.new(6,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . .", feToStringName(PBFields::BIGTOPA, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(6,"Encore lasts <c=green>6</c> turns"),
    PBFieldNote.new(6,"Certain stat moves' effect <icon=fieldUp> . . . ","Dragon Dance, Quiver Dance, Swords Dance, Feather Dance"),
    PBFieldNote.new(6,"Sing's Accuracy <icon=fieldChange> <c=green>100</c> "),
    PBFieldNote.new(6,"Rain Dance lasts <c=green>8</c> turns"),
    PBFieldNote.new(6,"Belly Drum <c=green>boosts</c> Def/Sp.Def"),
    PBFieldNote.new(6,"Spotlight <c=green>boosts</c> Atk/Sp.Atk . . .", "...of both the target and user."),
    PBFieldNote.new(6,"Dancer <c=green>boosts</c> Speed and Sp.Atk . . .","...when a Dance move is used on its own turn."),
    PBFieldNote.new(6,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::BIGTOPA, :NATUREMOVES)}"),
    PBFieldNote.new(6,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::BIGTOPA, :MIMICRY))}> "),
    PBFieldNote.new(6,"Secret Power <icon=fieldChange> <c=red>lowers</c> Sp.Def"),
    PBFieldNote.new(6,"Activates <c=orange>Synthetic Seed</c>. . .","Boosts Attack and applies Helping Hand to the user."),
  #Burning Field
    PBFieldNote.new(7,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::BURNINGF, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(7,"End of turn <icon=fieldFire> <c=orange>damage</c> when . . .","...when grounded and not Fire type."),
    PBFieldNote.new(7,"<c=green>Immunity</c> to <c=orange>field damage</c> when . . .", "...when one of these abilities is active: Flame Body, Flare Boost, Flash Fire, Heatproof, Magma Armor, Water Bubble, Water Veil."),
    PBFieldNote.new(7,"<c=orange>Field damage</c> <icon=fieldUp> when . . .","...when one of these abilities is active: Fluffy, Grass Pelt, Ice Body, Leaf Guard"),
    PBFieldNote.new(7,"<c=green>Created</c> by Grass <icon=fieldPlus> Fire Pledge"),
    PBFieldNote.new(7,"<icon=fieldFire> attacks <icon=fieldUp> <c=green>x1.5</c> when . . .","...when attacker is grounded."),
    PBFieldNote.new(7,"<icon=fieldGrass> attacks <icon=fieldDown> <c=red>x0.5</c> when . . .","...when target is grounded."),
    PBFieldNote.new(7,"<icon=fieldIce> attacks <icon=fieldDown> <c=red>x0.5</c> "),
    PBFieldNote.new(7,"<c=red>Destroyed</c> by these moves . . .",feToStringName(PBFields::BURNINGF, :FIELDCHANGE, 0)),
    PBFieldNote.new(7,"<c=red>Destroyed</c> by Sand and Rain"),
    PBFieldNote.new(7,"<c=green>Activates</c> certain abilities . . .","Blaze, Flare Boost, Flash Fire"),
    PBFieldNote.new(7,"Will-O-Wisp's Accuracy <icon=fieldChange> <c=green>100</c> "),
    PBFieldNote.new(7,"Pokémon cannot be <c=red>frozen</c> "),
    PBFieldNote.new(7,"Smokescreen effect <icon=fieldUp> "),
    PBFieldNote.new(7,"Fire Spin damage <icon=fieldChange> <c=green>1/6 HP</c> "),
    PBFieldNote.new(7,"Certain attacks <icon=fieldPlus> <icon=fieldFire> . . . ",feToStringName(PBFields::BURNINGF, :MOVETYPEMOD, PBTypes::FIRE)),
    PBFieldNote.new(7,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::BURNINGF, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(7,"Certain attacks <icon=fieldUp> <c=green>x2</c> . . . ",feToStringName(PBFields::BURNINGF, :MOVEDAMAGEBOOST, 2.0)),
    PBFieldNote.new(7,"<c=green>Restores</c> <icon=fieldFire> after Burn Up"),
    PBFieldNote.new(7,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::BURNINGF, :NATUREMOVES)}"),
    PBFieldNote.new(7,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::BURNINGF, :MIMICRY))}> "),
    PBFieldNote.new(7,"Secret Power <icon=fieldChange> <icon=fieldBurn> "),
    PBFieldNote.new(7,"Activates <c=orange>Elemental Seed</c>. . .","Boosts Attack, Special Attack and Speed, but applies Fire Spin to the user."),
  #Swamp Field
    PBFieldNote.new(8,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::SWAMPF, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(8,"Pokémon's Speed <icon=fieldDown> each turn."),
    PBFieldNote.new(8,"Pokémon <c=red>immune</c> to <c=orange>slow</c> when . . .", "...when airborne."),
    PBFieldNote.new(8,"<c=green>Created</c> by Water <icon=fieldPlus> Grass Pledge"),
    PBFieldNote.new(8,"Ingrain <c=red>damages</c> user unless . . .", "...unless user has Poison or Steel type."),
    PBFieldNote.new(8,"Dry Skin slowly <c=green>restores HP</c> "),
    PBFieldNote.new(8,"Aqua Ring recovery <icon=fieldChange> <c=green>1/8 HP</c> "),
    PBFieldNote.new(8,"<icon=fieldPoison> attacks <icon=fieldUp> <c=green>x1.5</c> when. . .","...when target is grounded."),
    PBFieldNote.new(8,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::SWAMPF, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(8,"Certain attacks <icon=fieldDown> <c=red>x0.25</c> . . . ",feToStringName(PBFields::SWAMPF, :MOVEDAMAGEBOOST, 0.25)),
    PBFieldNote.new(8,"Certain attacks <icon=fieldPlus> <icon=fieldWater> . . . ",feToStringName(PBFields::SWAMPF, :MOVETYPEMOD, PBTypes::WATER)),
    PBFieldNote.new(8,"<c=red>Prevents</c> use of these moves . . .","Explosion, Mind Blown, Self-Destruct"),
    PBFieldNote.new(8,"Sleep Powder's Accuracy <icon=fieldChange> <c=green>100</c> "),
    PBFieldNote.new(8,"<icon=fieldSleep> Pokémon <c=red>damaged</c> each turn"),
    PBFieldNote.new(8,"Gooey effect <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(8,"<c=green>Activates</c> Water Compaction . . .", "...each turn."),
    PBFieldNote.new(8,"Strength Sap recovery <icon=fieldUp> <c=green>30 %</c> "),
    PBFieldNote.new(8,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::SWAMPF, :NATUREMOVES)}"),
    PBFieldNote.new(8,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::SWAMPF, :MIMICRY))}> "),
    PBFieldNote.new(8,"Secret Power <icon=fieldChange> <c=red>lowers</c> Speed"),
    PBFieldNote.new(8,"Activates <c=orange>Telluric Seed</c>. . .","Boosts Defense and Sp.Def and applies Ingrain to the user."),
  #Rainbow Field
    PBFieldNote.new(9,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::RAINBOWF, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(9,"Secondary effect chance <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(9,"<c=green>Created</c> by Fire <icon=fieldPlus> Water Pledge"),
    PBFieldNote.new(9,"<c=green>Created</c> by Sun <icon=fieldPlus> Rain"),
    PBFieldNote.new(9,"Cloud Nine slowly <c=green>boosts</c> stats"),
    PBFieldNote.new(9,"<c=green>Activates</c> Marvel Scale"),
    PBFieldNote.new(9,"Wonder Skin always <c=green>activates</c> "),
    PBFieldNote.new(9,"Special <icon=fieldNormal> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(9,"Special <icon=fieldNormal> attacks <icon=fieldPlus> <icon=fieldQmark> ","Special Normal attacks gain a random type."),
    PBFieldNote.new(9,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::RAINBOWF, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(9,"Certain attacks <icon=fieldDown> <c=red>x0.5</c> . . . ",feToStringName(PBFields::RAINBOWF, :MOVEDAMAGEBOOST, 0.5)),
    PBFieldNote.new(9,"Certain stat moves' effect <icon=fieldUp> . . . ","Cosmic Power, Meditate"),
    PBFieldNote.new(9,"Certain attacks <icon=fieldChange> <c=green>no charge turn</c> ","Solar Beam, Solar Blade"), 
    PBFieldNote.new(9,"Wish recovery <icon=fieldChange> <c=green>75 % HP</c> "),
    PBFieldNote.new(9,"Nightmare and Bad Dreams <c=red>fail</c> "),
    PBFieldNote.new(9,"<icon=fieldSleep> Pokémon <c=green>recover</c> each turn"),
    PBFieldNote.new(9,"Sonic Boom damage <icon=fieldChange> <c=green>140</c> "),
    PBFieldNote.new(9,"<c=red>Destroyed</c> when . . .","...when Sand or Hail are in effect, or Light That Burns The Sky is used."),
    PBFieldNote.new(9,"<c=green>Enables</c> Aurora Veil"),
    PBFieldNote.new(9, "Soul Heart also <c=green>boosts</c> Sp.Def"),
    PBFieldNote.new(9,"Prism Armor <c=green>lowers damage</c>x0.5"),
    PBFieldNote.new(9,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::RAINBOWF, :NATUREMOVES)}"),
    PBFieldNote.new(9,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::RAINBOWF, :MIMICRY))}> "),
    PBFieldNote.new(9,"Secret Power <icon=fieldChange> random status"),
    PBFieldNote.new(9,"Activates <c=orange>Magical Seed</c>. . .","Boosts Sp.Atk and applies Wish to the user."),
  #Corrosive Field
    PBFieldNote.new(10,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::CORROSIVEF, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(10,"Deals <icon=fieldPoison> <c=orange>hazard damage</c> when . . .","...when grounded."),
    PBFieldNote.new(10,"No <c=orange>hazard damage</c> when . . .", "...when  Poison or Steel type, or one of these abilities is active: Immunity, Poison Heal, Toxic Boost, Wonder Guard" ),
    PBFieldNote.new(10,"Ingrain <c=red>damages</c> user unless . . .","...unless Poison or Steel type."),
    PBFieldNote.new(10,"Grass Pelt <c=red>damages</c> user unless","...unless Poison or Steel type."),
    PBFieldNote.new(10,"<c=green>Activates</c> certain abilities when . . .","...when grounded, activates Poison Heal and Toxic Boost."),
    PBFieldNote.new(10,"<icon=fieldGrass> attacks <icon=fieldPlus> <icon=fieldPoison> "),
    PBFieldNote.new(10,"Certain attacks <icon=fieldPlus> <icon=fieldPoison> . . . ",feToStringName(PBFields::CORROSIVEF, :MOVETYPEMOD, PBTypes::POISON)),
    PBFieldNote.new(10,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::CORROSIVEF, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(10,"Certain attacks <icon=fieldUp> <c=green>x2</c> . . . ",feToStringName(PBFields::CORROSIVEF, :MOVEDAMAGEBOOST, 2.0)),
    PBFieldNote.new(10,"Certain stat moves' effect <icon=fieldUp> . . . ","Acid Armor"),
    PBFieldNote.new(10,"<c=green>Activates</c> Venom Drench"),
    PBFieldNote.new(10,"<c=green>Activates</c> Venoshock"),
    PBFieldNote.new(10,"Certain moves' Accuracy <icon=fieldChange> <c=green>100</c> ","Poison Powder, Sleep Powder, Stun Spore, Toxic"),
    PBFieldNote.new(10,"<icon=fieldSleep> Pokémon <c=red>damaged</c> unless . . .", "...unless Poison or Steel Type, or has Wonder Guard."),
    PBFieldNote.new(10,"Toxic Spikes <c=red>can't</c> be absorbed"),
    PBFieldNote.new(10,"Becomes <c=orange>Grassy Terrain</c> when . . .","...when Seed Flare is used."),
    PBFieldNote.new(10,"<c=green>Activates</c> Merciless"),
    PBFieldNote.new(10,"Corrosion damage <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(10,"Floral Healing <icon=fieldPlus> <icon=fieldPoisonStatus> "),
    PBFieldNote.new(10,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::CORROSIVEF, :NATUREMOVES)}"),
    PBFieldNote.new(10,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::CORROSIVEF, :MIMICRY))}> "),
    PBFieldNote.new(10,"Secret Power <icon=fieldChange> <icon=fieldPoisonStatus> "),
    PBFieldNote.new(10,"Activates <c=orange>Telluric Seed</c> . . .","Applies Baneful Bunker to the user."),
  # Corrosive Mist Field
    PBFieldNote.new(11,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::CORROSIVEMISTF, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(11,"All Pokémon get <icon=fieldPoisonStatus> each turn"),
    PBFieldNote.new(11,"Aqua Ring <c=red>damages</c> user unless . . .", "...unless Poison or Steel type."),
    PBFieldNote.new(11,"Dry Skin <c=red>damages</c> user unless . . .", "...unless Poison or Steel type."),
    PBFieldNote.new(11,"Certain attacks <icon=fieldPlus> <icon=fieldPoison> . . . ","All special Flying moves, " + feToStringName(PBFields::CORROSIVEMISTF, :MOVETYPEMOD, PBTypes::POISON)),
    PBFieldNote.new(11,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::CORROSIVEMISTF, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(11,"Certain stat moves' effect <icon=fieldUp> . . . ","Acid Armor"),
    PBFieldNote.new(11,"<c=green>Activates</c> Venom Drench"),
    PBFieldNote.new(11,"<c=green>Activates</c> Venoshock"),
    PBFieldNote.new(11,"Toxic's Accuracy <icon=fieldChange> <c=green>100</c> "),
    PBFieldNote.new(11,"Aftermath damage <icon=fieldChange> <c=green>50 % HP</c> "),
    PBFieldNote.new(11,"<icon=fieldFire> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(11,"<c=green>Activates</c> Merciless"),
    PBFieldNote.new(11,"Corrosion damage <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(11,"Floral Healing <icon=fieldPlus> <icon=fieldPoisonStatus> "),
    PBFieldNote.new(11,"<c=green>Activates</c> Water Compaction . . .","...each turn."),
    PBFieldNote.new(11,"<c=red>Destroyed</c> by these moves . . .",feToStringName(PBFields::CORROSIVEMISTF, :FIELDCHANGE, 0)),
    PBFieldNote.new(11,"All Pokémon <icon=fieldFaint> when . . .", "...unless they have Flash Fire, when one of these moves is used in the absence of Damp: " + (PBFields::IGNITEMOVES + [PBMoves::SELFDESTRUCT, PBMoves::EXPLOSION]).map {|id| PBMoves.getName(id)}.sort.join(", ")),
    PBFieldNote.new(11,"Becomes <c=orange>Corrosive Field</c> when . . .","...when Gravity is used."),
    PBFieldNote.new(11,"Becomes <c=orange>Misty Terrain</c> when . . .","...when Seed Flare is used."),
    PBFieldNote.new(11,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::CORROSIVEMISTF, :NATUREMOVES)}"),
    PBFieldNote.new(11,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::CORROSIVEMISTF, :MIMICRY))}> "),
    PBFieldNote.new(11,"Secret Power <icon=fieldChange> <icon=fieldPoisonStatus> "),
    PBFieldNote.new(11,"Activates <c=orange>Elemental Seed</c> . . .","Boosts Attack and Sp.Atk and badly poisons the user."),
  #Desert Field
    PBFieldNote.new(12,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::DESERTF, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(12,"<icon=fieldGround> Pokémon's Sp.Def <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(12,"<c=green>Activates </c> certain abilities . . .","Sand Force, Sand Rush, Sand Veil"),
    PBFieldNote.new(12,"Sun and Sand last <c=green>8</c> turns"),
    PBFieldNote.new(12,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::DESERTF, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(12,"Sand Attack's effect <icon=fieldUp> "),
    PBFieldNote.new(12,"Dry Skin <c=red>damages</c> user"),
    PBFieldNote.new(12,"Sand Tomb damage <icon=fieldChange> <c=green>1/6 HP</c> per turn"),
    PBFieldNote.new(12,"<icon=fieldWater> attacks <icon=fieldDown> <c=red>x0.5</c> when . . .","...when attacker is grounded."),
    PBFieldNote.new(12,"<icon=fieldElectric> attacks <icon=fieldDown> <c=red>x0.5</c> when . . .","...when target is grounded."),
    PBFieldNote.new(12,"Shore Up heals <c=green>100 %</c> Max HP"),
    PBFieldNote.new(12,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::DESERTF, :NATUREMOVES)}"),
    PBFieldNote.new(12,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::DESERTF, :MIMICRY))}> "),
    PBFieldNote.new(12,"Secret Power <icon=fieldChange> <c=red>lowers</c> Accuracy"),
    PBFieldNote.new(12,"Activates <c=orange>Telluric Seed</c> . . .","Boosts Defense, Sp.Def, and Speed but applies Sand Tomb to the user."),
  #Icy Field
    PBFieldNote.new(13,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::ICYF, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(13,"Certain moves <c=green>boost</c> speed when . . .","...when attacker is grounded, these moves boost Speed: All attacking physical contact priority moves, Defense Curl, Feint, Lunge, Rollout, Steamroller"),
    PBFieldNote.new(13,"<icon=fieldIce> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(13,"<icon=fieldFire> attacks <icon=fieldDown> <c=green>x0.5</c> "),
    PBFieldNote.new(13,"Certain attacks <icon=fieldDown> <c=red>x0.5</c> . . . ",feToStringName(PBFields::ICYF, :MOVEDAMAGEBOOST, 0.5)),
    PBFieldNote.new(13,"<icon=fieldRock> attacks <icon=fieldPlus> <icon=fieldIce> "),
    PBFieldNote.new(13,"<icon=fieldIce> Pokémon's Defense <icon=fieldUp> <c=green>x1.5</c> when . . .", "...when Hail is up"),
    PBFieldNote.new(13,"<icon=fieldBurn> damage <icon=fieldDown> <c=red>x0.5</c> "),
    PBFieldNote.new(13,"Becomes <c=orange>Water Surface</c> when . . .", "...when #{feToStringName(PBFields::ICYF, :FIELDCHANGE, PBFields::WATERS)} is used, or if Water Surface is already under the ice and #{PBFields::QUAKEMOVES.map {|id| PBMoves.getName(id)}.sort.join(", ")} is used. Also turns into Water Surface if Scald or Steam Eruption is used twice."),
    PBFieldNote.new(13,"<c=green>Creates</c> a layer of spikes when . . .", "...when one of these moves is used and Water Surface isn't beneath the ice: #{PBFields::QUAKEMOVES.map {|id| PBMoves.getName(id)}.sort.join(", ")}."),
    PBFieldNote.new(13,"Hail lasts <c=green>8</c> turns"),
    PBFieldNote.new(13,"<c=green>Activates</c> certain abilities . . .","Ice Body, Snow Cloak, Slush Rush"),
    PBFieldNote.new(13,"Refrigerate power boost <icon=fieldChange> <c=green>x1.5</c> "),
    PBFieldNote.new(13,"<c=green>Enables</c> Aurora Veil"),
    PBFieldNote.new(13,"Liquid Voice <icon=fieldChange> <icon=fieldIce> "),
    PBFieldNote.new(13,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::ICYF, :NATUREMOVES)}"),
    PBFieldNote.new(13,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::ICYF, :MIMICRY))}> "),
    PBFieldNote.new(13,"Secret Power <icon=fieldChange> <icon=fieldFreeze> "),
    PBFieldNote.new(13,"Activates <c=orange>Elemental Seed</c> . . .","Boosts Speed two stages, but damages the user with Spikes."),
  #Rocky Field
    PBFieldNote.new(14,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::ROCKYF, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(14,"Pokémon can <c=orange>dodge</c> when . . .", "...when Evasion is increased or Substitute is up, attacks that can be blocked by Bulletproof can be dodged behind rocks."),
    PBFieldNote.new(14,"Missed contact moves <c=orange>recoil</c> . . .","...unless user has Rock Head."),
    PBFieldNote.new(14,"Stealth Rock damage <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(14,"Flinched Pokémon take <c=orange>recoil</c> . . .", "...unless target has Steadfast or Sturdy."),
    PBFieldNote.new(14,"Certain attacks <icon=fieldPlus> <icon=fieldRock> . . .",feToStringName(PBFields::ROCKYF, :MOVETYPEMOD, PBTypes::ROCK)),
    PBFieldNote.new(14,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::ROCKYF, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(14,"<icon=fieldRock> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(14,"Rock Smash <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(14,"Rock Polish's effect <icon=fieldUp> "),
    PBFieldNote.new(14,"Long Reach accuracy <icon=fieldDown> <c=red>x0.9</c> "),
    PBFieldNote.new(14,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::ROCKYF, :NATUREMOVES)}"),
    PBFieldNote.new(14,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::ROCKYF, :MIMICRY))}> "),
    PBFieldNote.new(14,"Secret Power <icon=fieldChange> Flinches"),
    PBFieldNote.new(14,"Activates <c=orange>Telluric Seed</c> . . .","Boosts Defense and Evasion, but damages the user with Stealth Rocks."),
  #Forest Field
    PBFieldNote.new(15,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::FORESTF, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(15,"Effect Spore chance <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(15,"<c=green>Activates</c> certain abilities . . .", "Grass Pelt, Leaf Guard, Overgrow, Swarm"),
    PBFieldNote.new(15,"<icon=fieldGrass> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(15,"Special <icon=fieldBug> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(15,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::FORESTF, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(15,"Cut <icon=fieldChange> <c=green>x2</c> vs <icon=fieldGrass> " ),
    PBFieldNote.new(15,"Certain attacks <icon=fieldDown> <c=red>x0.5</c> . . . ",feToStringName(PBFields::FORESTF, :MOVEDAMAGEBOOST, 0.5)),
    PBFieldNote.new(15,"Sap Sipper slowly <c=green>restores HP</c> "),
    PBFieldNote.new(15,"Ingrain recovery <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(15,"Certain stat moves' effect <icon=fieldUp> . . .","Defend Order, Growth"),
    PBFieldNote.new(15,"Heal Order recovery <icon=fieldChange> <c=green>66 %</c> "),
    PBFieldNote.new(15,"Sticky Web effect <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(15,"Long Reach accuracy <icon=fieldDown> <c=red>x0.9</c> "),
    PBFieldNote.new(15,"Strength Sap recovery <icon=fieldChange> <c=green>66 %</c> "),
    PBFieldNote.new(15,"Nature's Madness damage <icon=fieldChange> <c=green>75 %</c> "),
    PBFieldNote.new(15,"Forest's Curse <icon=fieldPlus> Curse effect"),
    PBFieldNote.new(15,"Becomes a <c=orange>Burning Field</c> when . . .", "...when #{feToStringName(PBFields::FORESTF, :FIELDCHANGE, PBFields::BURNINGF)} is used in the absence of Rain or Water Sport"),
    PBFieldNote.new(15,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::FORESTF, :NATUREMOVES)}"),
    PBFieldNote.new(15,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::FORESTF, :MIMICRY))}> "),
    PBFieldNote.new(15,"Secret Power <icon=fieldChange> <icon=fieldSleep> "),
    PBFieldNote.new(15,"Activates <c=orange>Telluric Seed</c> . . .","Applies Spiky Shield to the user."),
  #Super-Heated Field
    PBFieldNote.new(16,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::SUPERHEATEDF, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(16,"<icon=fieldFire> attacks <icon=fieldUp> <c=green>x1.1</c> "),
    PBFieldNote.new(16,"<icon=fieldIce> attacks <icon=fieldDown> <c=red>x0.5</c> "),
    PBFieldNote.new(16,"<icon=fieldWater> attacks <icon=fieldDown> <c=red>x0.9</c> "),
    PBFieldNote.new(16,"Certain attacks <icon=fieldDown> <c=red>x0.5</c> . . . ",feToStringName(PBFields::SUPERHEATEDF, :MOVEDAMAGEBOOST, 0.625)),
    PBFieldNote.new(16,"Certain moves generate <c=orange>steam</c> . . .","Hydro Vortex, Muddy Water, Oceanic Operetta, Sparkling Aria, Surf, Water Pledge, Water Sport, and Water Spout generate steam, lowering all active Pokémon's Accuracy."),
    PBFieldNote.new(16,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::SUPERHEATEDF, :MOVEDAMAGEBOOST, 1.667)),
    PBFieldNote.new(16,"Becomes <c=orange>Burning Field</c> when . . .","...when #{feToStringName(PBFields::SUPERHEATEDF, :FIELDCHANGE, PBFields::BURNINGF)} is used in the absence of Rain or Water Sport."),
    PBFieldNote.new(16,"<c=red>Destroyed</c> by these moves . . .", feToStringName(PBFields::SUPERHEATEDF, :FIELDCHANGE, 0)),
    PBFieldNote.new(16,"Hail is <c=red>terminated</c> "),
    PBFieldNote.new(16,"Attacks fatigue after <c=red>1</c> turn . . .","Applies to Outrage, Petal Dance, and Thrash"),
    PBFieldNote.new(16,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::SUPERHEATEDF, :NATUREMOVES)}"),
    PBFieldNote.new(16,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::SUPERHEATEDF, :MIMICRY))}> "),
    PBFieldNote.new(16,"Secret Power <icon=fieldChange> <icon=fieldBurn> "),
    PBFieldNote.new(16,"Activates <c=orange>Telluric Seed</c> . . .","Boosts Defense and applies Shell Trap to the user."),
  #Factory Field
    PBFieldNote.new(17,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::FACTORYF, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(17,"<icon=fieldElectric> attacks <icon=fieldUp> <c=green>x1.2</c> "),
    PBFieldNote.new(17,"Motor Drive boost <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(17,"Download boost <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(17,"Technician applies up to BP <c=green>80</c> "),
    PBFieldNote.new(17,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::FACTORYF, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(17,"Certain attacks <icon=fieldUp> <c=green>x2</c> . . . ",feToStringName(PBFields::FACTORYF, :MOVEDAMAGEBOOST, 2.0)),
    PBFieldNote.new(17,"Certain stat moves' effect <icon=fieldUp> . . .","Autotomize, Iron Defense, Metal Sound, Shift Gear"),
    PBFieldNote.new(17,"Magnet Rise lasts <c=green>8</c> turns"),
    PBFieldNote.new(17,"Becomes <c=orange>Short-Circuit</c> when . . .","...when #{feToStringName(PBFields::FACTORYF, :FIELDCHANGE, PBFields::SHORTCIRCUITF)} is used. Discharge additionally can alternate between the Short-Circuit and Factory Fields for each instance of damage in Double Battles."),
    PBFieldNote.new(17,"Gear Up boosts user and <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(17,"Galvanize power boost <icon=fieldChange> <c=green>x1.5</c> "),
    PBFieldNote.new(17,"Steelworker power boost <icon=fieldChange> <c=green>x2</c> "),
    PBFieldNote.new(17,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::FACTORYF, :NATUREMOVES)}"),
    PBFieldNote.new(17,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::FACTORYF, :MIMICRY))}> "),
    PBFieldNote.new(17,"Secret Power <icon=fieldChange> <c=red>lowers</c> Attack"),
    PBFieldNote.new(17,"Activates <c=orange>Synthetic Seed</c> . . .","Boosts Sp.Atk and applies Laser Focus to the user."),
  #Short-Circuit Field
    PBFieldNote.new(18,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::SHORTCIRCUITF, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(18,"Static chance <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(18,"Volt Absorb slowly <c=green>restores HP</c> "),
    PBFieldNote.new(18,"<c=green>Activates</c> Plus and Minus"),
    PBFieldNote.new(18,"<icon=fieldElectric> attacks <icon=fieldChange> sequential damage", "Damage rolls set multipliers between x0.5 and x2 on a specific pattern"),
    PBFieldNote.new(18,"Certain attacks <icon=fieldUp> <c=green>x1.3</c> . . . ",feToStringName(PBFields::SHORTCIRCUITF, :MOVEDAMAGEBOOST, 1.3)),
    PBFieldNote.new(18,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::SHORTCIRCUITF, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(18,"Certain attacks <icon=fieldDown> <c=red>x0.5</c> . . . ",feToStringName(PBFields::SHORTCIRCUITF, :MOVEDAMAGEBOOST, 0.5)),
    PBFieldNote.new(18,"Certain attacks <icon=fieldPlus> <icon=fieldElectric> . . .",feToStringName(PBFields::SHORTCIRCUITF, :MOVETYPEMOD, PBTypes::ELECTRIC)),
    PBFieldNote.new(18,"Becomes <c=orange>Factory Field</c> when . . .","...when #{feToStringName(PBFields::SHORTCIRCUITF, :FIELDCHANGE, PBFields::FACTORYF)} is used. Discharge additionally can alternate between the Short-Circuit and Factory Fields for each instance of damage in Double Battles."),
    PBFieldNote.new(18,"Certain stat moves' effect <icon=fieldUp> . . .","Flash, Metal Sound"),
    PBFieldNote.new(18,"Zap Cannon's Accuracy <icon=fieldChange> <c=green>80</c> "),
    PBFieldNote.new(18,"Magnet Rise lasts for <c=green>8</c> turns"),
    PBFieldNote.new(18,"<c=green>Activates</c> Surge Surfer"),
    PBFieldNote.new(18,"Galvanize power boost <icon=fieldChange> <c=green>x2</c> "),
    PBFieldNote.new(18,"Steelworker <icon=fieldPlus> <icon=fieldElectric> "),
    PBFieldNote.new(18,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::SHORTCIRCUITF, :NATUREMOVES)}"),
    PBFieldNote.new(18,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::SHORTCIRCUITF, :MIMICRY))}> "),
    PBFieldNote.new(18,"Secret Power <icon=fieldChange> <icon=fieldParalyze> "),
    PBFieldNote.new(18,"Activates <c=orange>Synthetic Seed</c> . . .","Boosts Sp.Def and applies Magnet Rise to the user."),
  #Wasteland
    PBFieldNote.new(19,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::WASTELAND, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(19,"Entry hazards are <c=orange>consumed</c> . . .","Consumed hazards return at the end of the turn, returning a special effect to the side they were on: \n Stealth Rocks deal type-scaling Rock damage double the normal effect to Pokémon. \n Spikes deal 33% max HP to grounded Pokémon. \n Toxic Spikes deal 12.5% max HP to grounded non-Poison/Steel types, and inflicts Poison. \n Sticky Web severely lowers Pokémon's Speed."),
    PBFieldNote.new(19,"Certain attacks <icon=fieldUp> <c=green>x1.2</c> . . . ",feToStringName(PBFields::WASTELAND, :MOVEDAMAGEBOOST, 1.2)),
    PBFieldNote.new(19,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::WASTELAND, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(19,"Certain attacks <icon=fieldDown> <c=red>x0.25</c> . . . ",feToStringName(PBFields::WASTELAND, :MOVEDAMAGEBOOST, 0.25)),
    PBFieldNote.new(19,"Certain attacks <icon=fieldPlus> <icon=fieldPoison> . . .",feToStringName(PBFields::WASTELAND, :MOVETYPEMOD, PBTypes::POISON)),
    PBFieldNote.new(19,"Certain moves <icon=fieldPlus> random status . . .","Acid Downpour, Gunk Shot, Octazooka, Sludge, Sludge Bomb, Sludge Wave inflict a random status unless target has Poison or Steel type, or one of these abilities: Immunity, Poison Heal, Toxic Boost"),
    PBFieldNote.new(19,"Certain abilities' chance <icon=fieldUp> <c=green>x2</c> ","Effect Spore, Poison Point, Stench"),
    PBFieldNote.new(19,"Liquid Ooze damage <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(19,"<c=green>Activates</c> certain abilities . . .", "Poison Heal, Toxic Boost, Merciless"),
    PBFieldNote.new(19,"Gooey effect <icon=fieldPlus> <icon=fieldPoisonStatus> "),
    PBFieldNote.new(19,"<c=green>Activates</c> Venom Drench and Venoshock"),
    PBFieldNote.new(19,"Spit Up <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(19,"Swallow <icon=fieldUp> <c=green>x2</c> <icon=fieldPlus> <c=green>cure</c> when max stack"),
    PBFieldNote.new(19,"Leech Seed effect <icon=fieldUp> <c=green>x2</c>"),
    PBFieldNote.new(19,"Corrosion attacks <icon=fieldPlus> <icon=fieldAllStat> "),
    PBFieldNote.new(19,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::WASTELAND, :NATUREMOVES)}"),
    PBFieldNote.new(19,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::WASTELAND, :MIMICRY))}> "),
    PBFieldNote.new(19,"Secret Power <icon=fieldChange> <icon=fieldAllStat> "),
    PBFieldNote.new(19,"Activates <c=orange>Telluric Seed</c> . . .","Boosts Attack and Sp.Atk and lays Stealth Rocks on both sides of the battle."),
  #Ashen Beach
    PBFieldNote.new(20,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::ASHENB, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(20,"Certain attacks stir up <c=orange>ash</c> . . .","All Special Flying attacks, Fire Spin, Leaf Tornado, Razor Wind, Twister, and Whirlpool stir up ash, lowering all active Pokémon's Accuracy."),
    PBFieldNote.new(20,"<icon=fieldFighting> Pokémon or Pokémon with . . ."," ...with Inner Focus can't get confused."),
    PBFieldNote.new(20,"Accuracy/Evasion <c=red>ignored</c> when . . .","...when the target does not have Unnerve, and one of these abilities is active: Own Tempo, Pure Power, Sand Veil, Steadfast"),
    PBFieldNote.new(20,"<c=green>Activates</c> certain abilities . . .", "Sand Force, Sand Rush, Sand Veil"),
    PBFieldNote.new(20,"Zen Mode <c=green>always active</c> "),
    PBFieldNote.new(20,"Certain stat moves' effect <icon=fieldUp> . . .","Calm Mind, Kinesis, Meditate, Sand Attack"),
    PBFieldNote.new(20,"Sand lasts <c=green>8</c> turns"),
    PBFieldNote.new(20,"Psych-Up <icon=fieldPlus> <c=green>cures</c> status"),
    PBFieldNote.new(20,"Focus Energy's effect <icon=fieldUp> "),
    PBFieldNote.new(20,"Certain attacks <icon=fieldUp> <c=green>x2</c> . . . ",feToStringName(PBFields::ASHENB, :MOVEDAMAGEBOOST, 2.0)),
    PBFieldNote.new(20,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::ASHENB, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(20,"Certain attacks <icon=fieldUp> <c=green>x1.3</c> . . . ",feToStringName(PBFields::ASHENB, :MOVEDAMAGEBOOST, 1.3)),
    PBFieldNote.new(20,"Psychic <icon=fieldUp> <c=green>x1.2</c> "),
    PBFieldNote.new(20,"Strength <icon=fieldChange> <icon=fieldFighting>/<icon=fieldPsychic> damage"),
    PBFieldNote.new(20,"Sand Tomb <icon=fieldPlus> <c=green>lowers</c> Accuracy"),
    PBFieldNote.new(20,"Water Compaction <c=green>boosts</c> Sp.Def"),
    PBFieldNote.new(20,"Focus Blasts's Accuracy <icon=fieldChange> <c=green>90</c> "),
    PBFieldNote.new(20,"Shore Up recovery <icon=fieldChange> <c=green>75 %</c> HP"),
    PBFieldNote.new(20,"Shell Bell recovery <icon=fieldChange> <c=green>25 %</c> damage dealt"),
    PBFieldNote.new(20,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::ASHENB, :NATUREMOVES)}"),
    PBFieldNote.new(20,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::ASHENB, :MIMICRY))}> "),
    PBFieldNote.new(20,"Secret Power <icon=fieldChange> <c=red>lowers</c> Accuracy"),
    PBFieldNote.new(20,"Activates <c=orange>Telluric Seed</c> . . .","Applies Focus Energy to the user."),
  #Water Surface
    PBFieldNote.new(21,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::WATERS, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(21,"Speed <icon=fieldDown> <c=red>x0.75</c> unless <icon=fieldWater> or . . .", "...unless Water type, airborne, or the abilities Surge Surfer or Swift Swim are active."),
    PBFieldNote.new(21,"<c=red>Prevents</c> <icon=fieldGround> attacks"),
    PBFieldNote.new(21,"Spikes/Toxic Spikes <c=red>terminated</c> "),
    PBFieldNote.new(21,"Dive lasts 1 turn"),
    PBFieldNote.new(21,"Water Veil <icon=fieldPlus> <c=green>cures</c> status"),
    PBFieldNote.new(21,"<c=green>Activates</c> certain abilities . . .","Hydration, Schooling, Surge Surfer, Swift Swim, Torrent, and Water Compaction each turn."),
    PBFieldNote.new(21,"Splash <icon=fieldPlus> <c=green>lowers</c> Accuracy"),
    PBFieldNote.new(21,"Aqua Ring recovery <icon=fieldChange> <c=green>1/8 HP</c> "),
    PBFieldNote.new(21,"Certain abilities <c=green>restore HP</c> . . .","Dry Skin, Water Absorb"),
    PBFieldNote.new(21,"Shore Up <c=green>activates</c> Water Compaction"),
    PBFieldNote.new(21,"Whirlpool damage <icon=fieldChange> <c=green>1/6 HP</c> "),
    PBFieldNote.new(21,"Whirlpool <icon=fieldPlus> confuses target"),
    PBFieldNote.new(21,"<icon=fieldWater> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(21,"<icon=fieldElectric> attacks <icon=fieldUp> <c=green>x1.5</c> when . . .","...when target is grounded."),   
    PBFieldNote.new(21,"<icon=fieldFire> attacks <icon=fieldDown> <c=red>x0.5</c> when . . .","...when target is grounded."),
    PBFieldNote.new(21,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::WATERS, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(21,"Becomes <c=orange>Underwater</c> when . . .","...when #{feToStringName(PBFields::WATERS, :FIELDCHANGE, PBFields::UNDERWATER)} is used."),
    PBFieldNote.new(21,"Becomes <c=orange>Icy Field</c> when . . .","...when #{feToStringName(PBFields::WATERS, :FIELDCHANGE, PBFields::ICYF)} is used."),
    PBFieldNote.new(21,"Becomes <c=orange>Murkwater</c> when . . .","...when Acid Downpour is used, or Sludge Wave is used twice."),
    PBFieldNote.new(21,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::WATERS, :NATUREMOVES)}"),
    PBFieldNote.new(21,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::WATERS, :MIMICRY))}> "),
    PBFieldNote.new(21,"Secret Power <icon=fieldChange> <c=red>lowers</c> Speed"),
    PBFieldNote.new(21,"Activates <c=orange>Elemental Seed</c> . . .","Boosts Sp.Def and applies Aqua Ring to the user."),
  #Underwater
    PBFieldNote.new(22,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::UNDERWATER, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(22,"Speed <icon=fieldDown> <c=red>x0.5</c> unless <icon=fieldWater> or . . .", "...unless Water type or Swift Swim is active."),
    PBFieldNote.new(22,"<c=red>Prevents</c> <icon=fieldFire> attacks"),
    PBFieldNote.new(22,"<c=red>Prevents</c> generated Fields"),
    PBFieldNote.new(22,"All weather is <c=red>terminated</c> "),
    PBFieldNote.new(22,"<icon=fieldWater> attacks <icon=fieldChange>x1 vs <icon=fieldWater> types"),
    PBFieldNote.new(22,"Physical damage <icon=fieldDown> <c=red>x0.5</c> unless . . .", "...unless attack is Water type or user has Steelworker."),
    PBFieldNote.new(22,"End of turn <icon=fieldWater> <c=orange>damage</c> when . . .", "...when Pokémon is weak to Water."),
    PBFieldNote.new(22,"<c=green>Immunity</c> to <c=orange>field damage</c> when . . .","...when the abilities Magic Guard or Swift Swim are active."),
    PBFieldNote.new(22,"<c=orange>Field damage</c> <icon=fieldRedUp> when . . .","...when the abilities Magma Armor or Flame Body are active."),
    PBFieldNote.new(22,"Dive lasts 1 turn"),
    PBFieldNote.new(22,"Water Veil <icon=fieldPlus> <c=green>cures</c> status"),
    PBFieldNote.new(22,"<c=green>Activates</c> certain abilities . . .","Hydration, Schooling, Surge Surfer, Swift Swim, Torrent, and Water Compaction each turn."),
    PBFieldNote.new(22,"Aqua Ring recovery <icon=fieldChange> <c=green>1/8 HP</c> "),
    PBFieldNote.new(22,"Certain abilities <c=green>restore HP</c> . . .","Dry Skin, Water Absorb"),
    PBFieldNote.new(22,"Whirlpool damage <icon=fieldChange> <c=green>1/6 HP</c> "),
    PBFieldNote.new(22,"Whirlpool <icon=fieldPlus> confuses target"),
    PBFieldNote.new(22,"<icon=fieldGround> attacks <icon=fieldPlus> <icon=fieldWater> damage"),
    PBFieldNote.new(22,"<icon=fieldWater> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(22,"<icon=fieldElectric> attacks <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(22,"<icon=fieldElectric> attacks <icon=fieldUp> <c=green>never miss</c> "),
    PBFieldNote.new(22,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::UNDERWATER, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(22,"Certain attacks <icon=fieldUp> <c=green>x2</c> . . . ",feToStringName(PBFields::UNDERWATER, :MOVEDAMAGEBOOST, 2.0)),
    PBFieldNote.new(22,"Becomes <c=orange>Water Surface</c> when . . .","...when #{feToStringName(PBFields::UNDERWATER, :FIELDCHANGE, PBFields::WATERS)} is used."),
    PBFieldNote.new(22,"Becomes <c=orange>Murkwater</c> when . . .","...when Acid Downpour is used, or Sludge Wave is used twice, KOing all non-Poison or Steel type Pokémon."),
    PBFieldNote.new(22,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::UNDERWATER, :NATUREMOVES)}"),
    PBFieldNote.new(22,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::UNDERWATER, :MIMICRY))}> "),
    PBFieldNote.new(22,"Secret Power <icon=fieldChange> <c=red>lowers</c> Attack"),
    PBFieldNote.new(22,"Activates <c=orange>Elemental Seed</c> . . .","Boosts Speed and applies Soak to the user."),
  #Cave
    PBFieldNote.new(23,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::CAVE, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(23,"<icon=fieldGround> attacks hit <icon=fieldFlying>/Levitate"),
    PBFieldNote.new(23,"All Pokémon <icon=fieldfaint> when . . .", "...when #{feToStringName(PBFields::CAVE, :FIELDCHANGE, PBFields::CAVE)} is used twice. Pokémon using Endure, or having Sturdy may survive with 1 HP from full health. Pokémon with Battle Armor and Shell Armor take 50% damage. Pokémon with Prism Armor or Solid Rock take 33% damage. Pokémon behind protect moves including Wide Guard, or having Bulletproof or Rock Head are immune to the damage."),
    PBFieldNote.new(23,"Fly and Bounce last 1 turn"),
    PBFieldNote.new(23,"<c=red>Prevents</c> Sky Drop"),
    PBFieldNote.new(23,"Stealth Rock damage <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(23,"<icon=fieldRock> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(23,"<icon=fieldFlying> attacks <icon=fieldDown> <c=red>x0.5</c> when . . .","...when non-contact."),
    PBFieldNote.new(23,"Sound-based moves <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(23,"Rock Tomb <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(23,"Becomes <c=orange>Crystal Cavern</c> when . . .","...when #{feToStringName(PBFields::CAVE, :FIELDCHANGE, PBFields::CRYSTALC)} is used."),
    PBFieldNote.new(23,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::CAVE, :NATUREMOVES)}"),
    PBFieldNote.new(23,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::CAVE, :MIMICRY))}> "),
    PBFieldNote.new(23,"Secret Power <icon=fieldChange> Flinches"),
    PBFieldNote.new(23,"Activates <c=orange>Telluric Seed</c> . . .","Boosts Defense by two stages and damages the user with Stealth Rocks."),
  #Glitch Field
    PBFieldNote.new(24,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::GLITCHF, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(24,"Type attacks <icon=fieldChange> always Physical . . .","Normal, Fighting, Poison, Ground, Flying, Bug, Rock, Ghost."),
    PBFieldNote.new(24,"Type attacks <icon=fieldChange> always Special . . .","Fire, Water, Grass, Electric, Ice, Psychic, Dragon."),
    PBFieldNote.new(24,"Special attacks <c=orange>calculate</c> on . . .","Special Attacks, for both the attacker and defender, calculate off of the higher stat between Sp.Atk and Sp.Def."),
    PBFieldNote.new(24,"<icon=fieldDark>, <icon=fieldSteel>, <icon=fieldFairy> moves <icon=fieldChange> <icon=fieldNormal> "),
    PBFieldNote.new(24,"The type chart is <c=orange>altered</c> . . .","Dragon always deals neutral damage. Bug now hits Poison types super-effectively. Ice now hits Fire types neutrally. Ghost now cannot hit Psychic types. Poison now hits Bug types super-effectively."),
    PBFieldNote.new(24,"Critical hit chance <icon=fieldUp> when . . .","Critical hit rate increases by one stage if attacker is faster than the target."),
    PBFieldNote.new(24,"Rage <c=red>locks</c> user into itself"),
    PBFieldNote.new(24,"Recharge moves don't have <c=green>recharge</c>. . .","...when the move knocks out a Pokémon"),
    PBFieldNote.new(24,"<icon=fieldPsychic> attacks <icon=fieldUp> <c=green>x1.2</c> "),
    PBFieldNote.new(24,"Blizzard's Accuracy <icon=fieldChange> <c=green>90</c> "),
    PBFieldNote.new(24,"Metronome <c=green>selects</c> attacks . . .","...selects attacks of 70 base power or higher only."),
    PBFieldNote.new(24,"Self-KO attacks <c=green>halve</c> Defense"),
    PBFieldNote.new(24,"RKS System <icon=fieldChange> <icon=fieldQmark> "),
    PBFieldNote.new(24,"<c=green>Created</c> when . . .", "Created for 5 turns when Conversion and Conversion2 are used in succession."),
    PBFieldNote.new(24,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::GLITCHF, :NATUREMOVES)}"),
    PBFieldNote.new(24,"Camouflage <icon=fieldChange> <icon=fieldQmark> "),
    PBFieldNote.new(24,"Secret Power <icon=fieldChange> <c=red>lowers</c> Speed"),
    PBFieldNote.new(24,"Activates <c=orange>Synthetic Seed</c> . . .","Boosts Defense and makes user ??? type."),
  #Crystal Cavern
    PBFieldNote.new(25,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::CRYSTALC, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(25,"<icon=fieldRock> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(25,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> ",feToStringName(PBFields::CRYSTALC, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(25,"Certain attacks <icon=fieldPlus> extra type","Rock Type attacks, as well as Judgment, Rock Climb, and Strength gain a sequential typing between Fire, Water, Grass and Psychic in that repeating pattern."),
    PBFieldNote.new(25,"<icon=fieldDragon> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(25,"Certain attacks <icon=fieldUp> <c=green>x1.3</c> ",feToStringName(PBFields::CRYSTALC, :MOVEDAMAGEBOOST, 1.3)),
    PBFieldNote.new(25,"Becomes <c=orange>Dark Crystal</c> when . . .","...when #{feToStringName(PBFields::CRYSTALC, :FIELDCHANGE, PBFields::DARKCRYSTALC)} is used."),
    PBFieldNote.new(25,"Becomes a <c=orange>Cave</c> when . . .","...when #{feToStringName(PBFields::CRYSTALC, :FIELDCHANGE, PBFields::CAVE)} is used."),
    PBFieldNote.new(25,"Rock Polish <icon=fieldPlus> <c=green>boosts</c> Atk/Sp.Atk"),
    PBFieldNote.new(25,"Stealth Rock <icon=fieldPlus> random damage","Stealth Rock randomly applies either Fire, Water, Grass or Psychic type damage."),
    PBFieldNote.new(25,"<c=green>Enables</c> Aurora Veil"),
    PBFieldNote.new(25,"Prism Armor <c=green>lowers damage</c> x0.5"),
    PBFieldNote.new(25,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::CRYSTALC, :NATUREMOVES)}"),
    PBFieldNote.new(25,"Camouflage <icon=fieldChange> random type . . .","Camouflage may choose one of Fire, Water, Grass or Psychic typings."),
    PBFieldNote.new(25,"Secret Power <icon=fieldChange> random status . . .","Secret Power may choose a random status between Burn, Freeze, Sleep or Confusion."),
    PBFieldNote.new(25,"Activates <c=orange>Magical Seed</c> . . .","Boosts Sp.Atk and applies Magic Coat to the user."),
  #Murkwater Surface
    PBFieldNote.new(26,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::MURKWATERS, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(26,"Speed <icon=fieldDown> <c=red>x0.75</c> unless <icon=fieldWater> or . . .", "...unless Water type, airborne, or the abilities Surge Surfer or Swift Swim are active."),
    PBFieldNote.new(26,"End of turn <icon=fieldPoison> <c=orange>damage</c> when . . .","...when grounded, and not Poison or Steel type."),
    PBFieldNote.new(26,"<c=green>Immunity</c> to field <c=orange>damage</c> when . . .","...when one of the following abilities is active: Immunity, Magic Guard, Poison Heal, Toxic Boost, Wonder Guard"),
    PBFieldNote.new(26,"Field <c=orange>damage</c> <icon=fieldRedUp> when . . .","...when Pokémon is underwater (x4) or has one of the following abilities (x2): Dry Skin, Flame Body, Magma Armor, Water Absorb"),
    PBFieldNote.new(26,"Dry Skin <c=green>restores HP</c> when . . .","...when grounded and Poison type."),
    PBFieldNote.new(26,"Water Absorb <c=green>restores HP</c> when . . .","...when grounded and Poison type."),
    PBFieldNote.new(26,"<c=green>Activates</c> certain abilities when . . .","...when grounded, activates Merciless, Poison Heal, Schooling, Surge Surfer, Swift Swim, Toxic Boost and Water Compaction each turn."),
    PBFieldNote.new(26,"<c=red>Prevents</c> <icon=fieldGround> attacks"),
    PBFieldNote.new(26,"Spikes/Toxic Spikes <c=red>terminated</c> "),
    PBFieldNote.new(26,"Shore Up <c=green>activates</c> Water Compaction"),
    PBFieldNote.new(26,"<icon=fieldWater> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(26,"<icon=fieldWater> attacks <icon=fieldPlus> <icon=fieldPoison> "),
    PBFieldNote.new(26,"<icon=fieldPoison> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(26,"<icon=fieldElectric> attacks <icon=fieldUp> <c=green>x1.3</c> when . . .","...when opponent is grounded."),
    PBFieldNote.new(26,"Sludge Wave <icon=fieldPlus> <icon=fieldWater> "),
    PBFieldNote.new(26,"Certain attacks <icon=fieldChange> <icon=fieldWater> / <icon=fieldPoison> ","Mud Bomb, Mud Shot, Mud-Slap, Thousand Waves"),
    PBFieldNote.new(26,"Certain attacks <icon=fieldPlus> <icon=fieldPoison> . . .","Smack Down"),
    PBFieldNote.new(26,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::MURKWATERS, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(26,"Gooey effect <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(26,"Stench chance <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(26,"Acid Armor's effect <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(26,"<c=green>Activates</c> Venoshock"),
    PBFieldNote.new(26,"<c=green>Activates</c> Venom Drench"),
    PBFieldNote.new(26,"Liquid Ooze <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(26,"Becomes <c=orange>Water Surface</c> when . . .","...when #{feToStringName(PBFields::MURKWATERS, :FIELDCHANGE, PBFields::WATERS)} is used."),
    PBFieldNote.new(26,"Becomes <c=orange>Icy Field</c> when . . .","...when #{feToStringName(PBFields::MURKWATERS, :FIELDCHANGE, PBFields::ICYF)} is used."),
    PBFieldNote.new(26,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::MURKWATERS, :NATUREMOVES)}"),
    PBFieldNote.new(26,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::MURKWATERS, :MIMICRY))}> "),
    PBFieldNote.new(26,"Secret Power <icon=fieldChange> <icon=fieldPoisonStatus> "),
    PBFieldNote.new(26,"Activates <c=orange>Elemental Seed</c> . . .","Boosts Speed and applies Aqua Ring, but poisons the user."),
  #Mountain
    PBFieldNote.new(27,"<c=orange>\"Adieu to disappointment and spleen,\"</c> ", "What are men to rocks and mountains?"),
    PBFieldNote.new(27,"Tailwind lasts <c=green>5</c> turns"),
    PBFieldNote.new(27,"Tailwind <icon=fieldPlus> Strong Winds"),
    PBFieldNote.new(27,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::MOUNTAIN, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(27,"Certain attacks <icon=fieldPlus> <icon=fieldUp> <c=green>x1.5</c> when . . .","...when Strong Winds are active, further boosts all Special Flying attacks, as well as Fairy Wind, Gust, Icy Wind, Ominous Wind, Razor Wind, Silver Wind, Twister"),
    PBFieldNote.new(27,"Sun lasts <c=green>8</c> turns"),
    PBFieldNote.new(27,"Thunder <c=green>never misses</c> "),
    PBFieldNote.new(27,"Becomes <c=orange>Snowy Mountain</c> when . . .","...when #{feToStringName(PBFields::MOUNTAIN, :FIELDCHANGE, PBFields::SNOWYM)} is used."),
    PBFieldNote.new(27,"<icon=fieldFlying> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(27,"<icon=fieldRock> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(27,"Long Reach damage <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(27,"<c=green>Activates</c> Gale Wings when windy"),
    PBFieldNote.new(27,"Aerilate power boost <icon=fieldChange> <c=green>x1.5</c> "),
    PBFieldNote.new(27,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::MOUNTAIN, :NATUREMOVES)}"),
    PBFieldNote.new(27,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::MOUNTAIN, :MIMICRY))}> "),
    PBFieldNote.new(27,"Secret Power <icon=fieldChange> Flinches"),
    PBFieldNote.new(27,"Activates <c=orange>Telluric Seed</c> . . .","Boosts Attack by two stages, but lowers Accuracy."),
  #Snowy Mountain
    PBFieldNote.new(28,"<c=orange>\"The snow glows white on the mountain\"</c> "),
    PBFieldNote.new(28,"Tailwind lasts <c=green>5</c> turns"),
    PBFieldNote.new(28,"Tailwind <icon=fieldPlus> Strong Winds"),
    PBFieldNote.new(28,"<icon=fieldRock> attacks <icon=fieldPlus> <icon=fieldIce> "),
    PBFieldNote.new(28,"<icon=fieldIce> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(28,"<icon=fieldRock> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(28,"<icon=fieldFlying> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(28,"<icon=fieldFire> attacks <icon=fieldDown> <c=red>x0.5</c> "),
    PBFieldNote.new(28,"<icon=fieldIce> Pokémon's Defense <icon=fieldUp> <c=green>x1.5</c> when . . .", "...when Hail is up"),
    PBFieldNote.new(28,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::SNOWYM, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(28,"Certain attacks <icon=fieldPlus> <icon=fieldUp> <c=green>x1.5</c> when . . .","...when Strong Winds are active, further boosts all Special Flying attacks, as well as Fairy Wind, Gust, Icy Wind, Ominous Wind, Razor Wind, Silver Wind, Twister"),
    PBFieldNote.new(28,"Certain attacks <icon=fieldDown> <c=red>x0.5</c> . . . ",feToStringName(PBFields::SNOWYM, :MOVEDAMAGEBOOST, 0.5)),
    PBFieldNote.new(28,"Sun and Hail last for <c=green>8</c> turns"),
    PBFieldNote.new(28,"Thunder <c=green>never misses</c> "),
    PBFieldNote.new(28,"<c=green>Activates</c> certain abilities . . .","Ice Body, Slush Rush, Snow Cloak"),
    PBFieldNote.new(28,"Refrigerate power boost <icon=fieldChange> <c=green>x1.5</c> "),
    PBFieldNote.new(28,"Becomes a <c=orange>Mountain</c> when . . .", "...when #{feToStringName(PBFields::SNOWYM, :FIELDCHANGE, PBFields::MOUNTAIN)} is used"),
    PBFieldNote.new(28,"<c=green>Activates</c> Gale Wings when windy"),
    PBFieldNote.new(28,"<c=green>Enables</c> Aurora Veil"),
    PBFieldNote.new(28,"Long Reach damage <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(28,"Aerilate power boost <icon=fieldChange> <c=green>x1.5</c> "),
    PBFieldNote.new(28,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::SNOWYM, :NATUREMOVES)}"),
    PBFieldNote.new(28,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::SNOWYM, :MIMICRY))}> "),
    PBFieldNote.new(28,"Secret Power <icon=fieldChange> <icon=fieldFreeze> "),
    PBFieldNote.new(28,"Activates <c=orange>Telluric Seed</c> . . .","Boosts Sp.Atk by two stages, but lowers Accuracy."),
  #Holy Field
    PBFieldNote.new(29,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::HOLYF, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(29,"The type chart is <c=orange>altered</c> . . .","Normal type attacks hit Ghost and Dark type Pokémon for super-effective damage."),
    PBFieldNote.new(29,"<icon=fieldGhost> attacks <icon=fieldDown> <c=red>x0.5</c> "),
    PBFieldNote.new(29,"Certain attacks <icon=fieldDown> <c=red>x0.5</c> . . . ","All special Dark type moves"),
    PBFieldNote.new(29,"Special <icon=fieldFairy> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(29,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::HOLYF, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(29,"Certain attacks <icon=fieldUp> <c=green>x1.3</c> . . . ",feToStringName(PBFields::HOLYF, :MOVEDAMAGEBOOST, 1.3)),
    PBFieldNote.new(29,"<icon=fieldPsychic> attacks <icon=fieldUp> <c=green>x1.2</c> "),
    PBFieldNote.new(29,"<icon=fieldDragon> attacks <icon=fieldUp> <c=green>x1.2</c> "),
    PBFieldNote.new(29,"Special <icon=fieldNormal> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(29,"Justified effect <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(29,"Wish recovery <icon=fieldChange> <c=green>75 % HP</c> "),
    PBFieldNote.new(29,"<c=red>Prevents</c> Cursed Body"),
    PBFieldNote.new(29,"Lifts Curse each turn"),
    PBFieldNote.new(29,"Allies <c=green>avoid</c> damage from  . . ","...allies avoid damage from their partner's moves"),
    PBFieldNote.new(29,"Miracle Eye <icon=fieldPlus> <c=green>boost</c> Sp.Atk"),
    PBFieldNote.new(29,"Cosmic Power's effect <icon=fieldUp> "),
    PBFieldNote.new(29,"Nature's Madness damage <icon=fieldChange> <c=green>75 % HP</c> "),
    PBFieldNote.new(29,"RKS System <icon=fieldChange> <icon=fieldDark> "),
    PBFieldNote.new(29,"<c=red>Destroyed</c> by these moves . . .", feToStringName(PBFields::HOLYF, :FIELDCHANGE, 0)),
    PBFieldNote.new(29,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::HOLYF, :NATUREMOVES)}"),
    PBFieldNote.new(29,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::HOLYF, :MIMICRY))}> "),
    PBFieldNote.new(29,"Secret Power <icon=fieldChange> <c=red>lowers</c> Sp.Atk"),
    PBFieldNote.new(29,"Activates <c=orange>Magical Seed</c> . . .","Boosts Sp.Atk and applies Magic Coat to the user."),
  #Mirror Field
    PBFieldNote.new(30,"<c=orange>\"Mirror, Mirror on the field . . .</c> ", "Who shalt this fractured power wield?"),
    PBFieldNote.new(30,"Critical hit rate <icon=fieldUp> when . . .","The critical hit rate is increased by one stage for each of the attacker's Evasion/Accuracy buffs, and the target's Evasion/Accuracy de-buffs."),
    PBFieldNote.new(30,"Certain attacks <c=orange>reflect</c> when . . .","Special, non-contact, single target attacks will always hit targets with raised evasion."),
    PBFieldNote.new(30,"Certain <c=orange>reflected</c> attacks <icon=fieldUp> <c=green>x2</c> . . .","Bubble Beam, Charge Beam, Fleur Cannon, Hyper Beam, Ice Beam, Origin Pulse, Moongeist Beam, Psybeam, Solar Beam, and Tri-Attack are boosted when hitting targets with raised evasion."),
    PBFieldNote.new(30,"Missing physical moves <c=orange>recoil</c> . . .","Missing a physical contact attack causes 1/4 Max HP recoil damage. Also Evasion is lowered by one stage if it's raised."),
    PBFieldNote.new(30,"Certain abilities <c=green>boost</c> Evasion . . .","Color Change, Illusion, Magic Bounce, Sand Veil, Snow Cloak, and Tangled Feet boost Evasion when switched in."),
    PBFieldNote.new(30,"Certain items <c=green>boost</c> Evasion . . .","Bright Powder and Lax Incense boost Evasion when switched in."),
    PBFieldNote.new(30,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> and . . .","...and never miss: #{feToStringName(PBFields::MIRRORA, :MOVEDAMAGEBOOST, 1.5)}"),
    PBFieldNote.new(30,"Illuminate <icon=fieldPlus> <c=green>lowers</c> Accuracy . . .","Illuminate lowers opponents' Accuracy on switch-in"),
    PBFieldNote.new(30,"Certain abilities <c=green>boost</c> Accuracy . . .","Keen Eye, Compound Eye raises Accuracy on switch-in. They additionally apply Laser Focus"),
    PBFieldNote.new(30,"Certain items <c=green>boost</c> Accuracy . . .","Wide Lens, Zoom Lens raises Accuracy on switch-in. They additionally apply Laser Focus"),
    PBFieldNote.new(30,"Magic Bounce <icon=fieldPlus> Evasion <icon=fieldUp> when . . .","...when an attack is successfully bounced."),
    PBFieldNote.new(30,"Screens last <c=green>8</c> turns"),
    PBFieldNote.new(30,"<c=green>Enables</c> Aurora Veil"),
    PBFieldNote.new(30,"Screens <icon=fieldPlus> Evasion <icon=fieldUp> "),
    PBFieldNote.new(30,"Mirror Coat <icon=fieldPlus> <c=green>boosts</c> stats . . .","Mirror Coat increases Evasion, Defense and Sp.Def on successful use."),
    PBFieldNote.new(30,"Mirror Move <icon=fieldPlus> <c=green>boosts</c> stats . . .","Mirror Move increases Accuracy, Attack and Sp.Atk on successful use."),
    PBFieldNote.new(30,"Mirror Shot <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(30,"Mirror Shot effect chance <icon=fieldChange> <c=green>100</c> "),
    PBFieldNote.new(30,"Certain stat moves' effect <icon=fieldUp> . . .", "Double Team, Flash"),
    PBFieldNote.new(30,"<c=red>Terminated</c> by these moves and . . .", "...and damages all active Pokémon for 1/2 their max HP: #{feToStringName(PBFields::MIRRORA, :FIELDCHANGE, 0)}.\nPokémon behind protect moves including Wide Guard, or having Shell Armor or Battle Armor are immune to the shatter damage."),
    PBFieldNote.new(30,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::MIRRORA, :NATUREMOVES)}"),
    PBFieldNote.new(30,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::MIRRORA, :MIMICRY))}> "),
    PBFieldNote.new(30,"Secret Power <icon=fieldChange> <c=red>lowers</c> Evasion"),
    PBFieldNote.new(30,"Activates <c=orange>Synthetic Seed</c> . . .","Boosts Evasion one stage and applies Mirror Coat."),
  #Fairy Tale Field
    PBFieldNote.new(31,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::FAIRYTALEF, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(31,"<icon=fieldFairy> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(31,"<icon=fieldSteel> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(31,"<icon=fieldDragon> attacks <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(31,"<icon=fieldSteel> attacks <icon=fieldChange> <c=green>x2</c> vs <icon=fieldDragon> "),
    PBFieldNote.new(31,"<icon=fieldFire> attacks <icon=fieldUp> <icon=fieldplus> <icon=fieldDragon> "),
    PBFieldNote.new(31,"Certain abilities <icon=fieldPlus> Defense <icon=fieldUp> . . .","Battle Armor, Power of Alchemy and Shell Armor boost Defense upon switching in."),
    PBFieldNote.new(31,"Certain abilities <icon=fieldPlus> Sp.Def <icon=fieldUp> . . .","Magic Guard, Magic Bounce and Power of Alchemy boost Sp.Def upon switching in."),
    PBFieldNote.new(31,"Magician <icon=fieldPlus> Sp.Atk <icon=fieldUp> when . . .","Magician boosts Sp.Atk upon switching in."),
    PBFieldNote.new(31,"Fairy Aura <icon=fieldPlus> moves <c=green>never miss</c> "),
    PBFieldNote.new(31,"<c=green>Activates</c> Marvel Scale"),
    PBFieldNote.new(31,"Certain attacks <icon=fieldChange> <icon=fieldSteel> ","Cut, Sacred Sword, Secret Sword, Slash"),
    PBFieldNote.new(31,"Stance Change <c=orange>alters</c> stats . . .","Pokémon with Stance Change boost and lower Attack and Defense one stage when switching between respective forms."),
    PBFieldNote.new(31,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::FAIRYTALEF, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(31,"Draining Kiss <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(31,"Certain attacks <icon=fieldPlus> <c=green>boost</c> stats . . .","Crafty Shield and Flower Shield additionally boost the user's Defense and Sp.Def one stage."),
    PBFieldNote.new(31,"Certain attacks <icon=fieldPlus> <c=green>protection</c> . . .","King's Shield additionally protects from non-damaging moves."),
    PBFieldNote.new(31,"King's Shield <icon=fieldPlus> <c=green>lowers</c> Sp.Atk"),
    PBFieldNote.new(31,"Certain stat moves' effect <icon=fieldUp> . . .","Acid Armor, Noble Roar, Swords Dance"),
    PBFieldNote.new(31,"Certain attacks <icon=fieldPlus> <c=green>cure</c> Sleep","Draining Kiss, Sweet Kiss"),
    PBFieldNote.new(31,"Wish recovery <icon=fieldChange> <c=green> 75 % HP</c> "),
    PBFieldNote.new(31,"Healing Wish <icon=fieldPlus> <c=green>boosts</c> stats . . .","Healing Wish boosts recipient's Attack and Special Attack"),
    PBFieldNote.new(31,"Miracle Eye <icon=fieldPlus> <c=green>boost</c> Sp.Atk"),
    PBFieldNote.new(31,"Forest's Curse <icon=fieldPlus> Curse effect"),
    PBFieldNote.new(31,"Floral Healing recovery <icon=fieldChange> <c=green>100 %</c> "),
    PBFieldNote.new(31,"Queenly Majesty damage <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(31,"Soul Heart also  <c=green>boosts</c> Sp.Def"),
    PBFieldNote.new(31,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::FAIRYTALEF, :NATUREMOVES)}"),
    PBFieldNote.new(31,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::FAIRYTALEF, :MIMICRY))}> "),
    PBFieldNote.new(31,"Secret Power <icon=fieldChange> <icon=fieldSleep> "),
    PBFieldNote.new(31,"Activates <c=orange>Magical Seed</c> . . .","Applies King's Shield to the user."),
  #Dragon's Den
    PBFieldNote.new(32,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::DRAGONSD, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(32,"<icon=fieldDragon> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(32,"<icon=fieldFire> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(32,"<icon=fieldWater> attacks <icon=fieldUp> <c=red>x0.5</c> "),
    PBFieldNote.new(32,"<icon=fieldIce> attacks <icon=fieldUp> <c=red>x0.5</c> "),
    PBFieldNote.new(32,"<icon=fieldDragon> Pokémon's defenses <icon=fieldUp> <c=green>x1.3</c>"),
    PBFieldNote.new(32,"<c=green>Activates</c> Marvel Scale"),
    PBFieldNote.new(32,"Multiscale <icon=fieldPlus> <c=green>protection</c> ","Multiscale additionally annulls user's Dragon type's weaknesses at all times"),
    PBFieldNote.new(32,"Shed Skin <icon=fieldPlus> <c=green>recovery</c> and . . . ","Shed Skin heals 25% on activation, and boosts Speed and Sp.Atk by one stage each while lowering Defense and Sp.Def one stage each."),
    PBFieldNote.new(32,"Certain attacks <icon=fieldPlus> <icon=fieldFire> . . .","#{feToStringName(PBFields::DRAGONSD, :MOVETYPEMOD, PBTypes::FIRE)}"),
    PBFieldNote.new(32,"Certain attacks <icon=fieldUp> <c=green>x2</c> . . . ",feToStringName(PBFields::DRAGONSD, :MOVEDAMAGEBOOST, 2.0)),
    PBFieldNote.new(32,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::DRAGONSD, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(32,"Magma Storm damage <icon=fieldChange> <c=green>1/6 HP</c> "),
    PBFieldNote.new(32,"Magma Armor <icon=fieldPlus> <c=green>boosts</c> stats . . .","Magma Armor boosts Defense and Sp.Def upon switching in."),
    PBFieldNote.new(32,"Magma Armor <icon=fieldPlus> <icon=fieldFire> <c=red>immunity</c> "),
    PBFieldNote.new(32,"Certain stat moves' effect <icon=fieldUp> . . .","Dragon Dance, Noble Roar"),
    PBFieldNote.new(32,"Becomes a <c=orange>Cave</c> when . . .","...when Glaciate, Hydro Vortex, Oceanic Operetta, or Subzero Slammer is used, or when Muddy Water, Sparkling Aria, or Surf is used twice."),
    PBFieldNote.new(32,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::DRAGONSD, :NATUREMOVES)}"),
    PBFieldNote.new(32,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::DRAGONSD, :MIMICRY))}> "),
    PBFieldNote.new(32,"Secret Power <icon=fieldChange> <icon=fieldBurn> "),
    PBFieldNote.new(32,"Activates <c=orange>Elemental Seed</c> . . .","Boosts Sp.Atk and applies Flash Fire's power boost to the user."),
  #Flower Garden Field
    PBFieldNote.new(33,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::FLOWERGARDENF, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(33,"<c=orange>Grows</c> from <c=orange>Stage 1</c> to <c=orange>Stage 5</c> "),
    PBFieldNote.new(33,"Certain attacks <c=orange>grow</c> 1 <c=orange>Stage</c> . . .","Bloom Doom, Growth, Rain Dance, Rototiller, Sunny Day, Water Sport.\nAdditionally, these abilities grow the field one stage on switch-in: Drizzle, Drought, Flower Gift, Flower Veil"),
    PBFieldNote.new(33,"Cut and X-Scissor <c=red>reduces</c> <c=orange>Stage</c> by 1","","<c=ffb347>2</c>+"),
    PBFieldNote.new(33,"<c=green>Activates</c> certain abilities . . .","Flower Gift, Swarm","<c=7CFC00>1</c>+"),
    PBFieldNote.new(33,"Rototiller's effect <icon=fieldUp> ","","<c=7CFC00>1</c>+"),
    PBFieldNote.new(33,"Rototiller <icon=fieldPlus> <c=green>boosts</c> stats . . .","Rototiller additionally boosts user's Attack and Sp.Atk.","<c=7CFC00>1</c>+"),
    PBFieldNote.new(33,"Growth's effect <icon=fieldUp> . . .","Increases (x2,x3) at Stages (1,3)","<c=7CFC00>1</c>,<c=ec5800>3</c> "),
    PBFieldNote.new(33,"Cut <icon=fieldUp> <c=green>x1.5</c> ","","<c=ffb347>2</c>+"),
    PBFieldNote.new(33,"Cut <icon=fieldChange> <c=green>x2</c> vs <icon=fieldGrass> ","","<c=ffb347>2</c>+"),
    PBFieldNote.new(33,"<c=green>Activates</c> certain abilities . . . ","Harvest, Leaf Guard","<c=ffb347>2</c>+"),
    PBFieldNote.new(33,"Flower Shield <icon=fieldPlus> <c=green>boosts</c> stats . . .","Flower Shield additionally boosts Sp.Def and the user's Defense and Sp.Def.","<c=ffb347>2</c>+"),
    PBFieldNote.new(33,"Certain attack's Accuracy <icon=fieldChange> <c=green>85</c> ","Poison Powder, Sleep Powder, Stun Spore","<c=ffb347>2</c>+"),
    PBFieldNote.new(33,"Flower Veil <icon=fieldPlus> <c=green>reduces</c> damage . . .","Flower Veil passively reduces damage x0.5 to its user and allied Grass types.","<c=ec5800>3</c>+"),
    PBFieldNote.new(33,"Becomes a <c=orange>Burning Field</c> when . . .","#{feToStringName(PBFields::FLOWERGARDENF, :FIELDCHANGE, PBFields::BURNINGF)} is used in the absence of Rain or Water Sport.","<c=ec5800>3</c>+"),
    PBFieldNote.new(33,"Sweet Scent <icon=fieldPlus> <c=green>lowers</c> defenses","","<c=ec5800>3</c>+"),
    PBFieldNote.new(33,"<icon=fieldFire> attacks <icon=fieldUp> <c=green>x1.5</c> ","","<c=ec5800>3</c>+"),
    PBFieldNote.new(33,"Flower Shield's effect <icon=fieldUp> ","","<c=ec5800>3</c>+"),
    PBFieldNote.new(33,"<c=green>Activates</c> Chlorophyll","","<c=ff2800>4</c>+"),
    PBFieldNote.new(33,"Grass type's weaknesses are <c=green>annulled</c> ","","<c=ff2800>4</c>+"),
    PBFieldNote.new(33,"Certain attacks <c=green>hit all</c> opposing","Petal Blizzard, Petal Dance, and all Powder moves hit both opposing Pokémon at Stage 5.","<c=ff00ff>5</c> "),
    PBFieldNote.new(33,"<icon=fieldGrass> attacks <icon=fieldUp> ","Grass type attacks increase in base power (x1.1,x1.3,x1.5,x2) at Stages (2,3,4,5).","<c=ffb347>2</c>-<c=ff00ff>5</c> "),
    PBFieldNote.new(33,"Damage <icon=fieldDown> vs <icon=fieldGrass> Pokémon . . .","Grass type Pokémon take damage reduced to (x0.75,x0.67,x0.5) at Stages (3,4,5).","<c=ffb347>2</c>-<c=ff00ff>5</c> "),
    PBFieldNote.new(33,"<icon=fieldBug> attacks <icon=fieldUp> . . .","Bug type attacks increase in base power (x1.5,x2) at Stages (2,4).","<c=ffb347>2</c>,<c=ff2800>4</c> "),
    PBFieldNote.new(33,"Swarm effect <icon=fieldUp> . . .","Swarm increases Bug type attacks' power by (x1.8,x2) at Stages (3,5).","<c=ec5800>3</c>,<c=ff00ff>5</c> "),
    PBFieldNote.new(33,"<c=green>Activates</c> Overgrow when . . .","Overgrow activates at (66% HP, Any HP amount) at Stages (2,3).","<c=ffb347>2</c>,<c=ec5800>3</c> "),
    PBFieldNote.new(33,"Overgrow's effect <icon=fieldUp> . . .","Overgrow increases Grass type attacks' power by (x1.8,x2) at Stages (4,5).","<c=ff2800>4</c>,<c=ff00ff>5</c> "),
    PBFieldNote.new(33,"Sweet Scent's effect <icon=fieldUp> . . .","At Stage 3 and later, Sweet Scent additionally lowers Defense and Sp.Def. Sweet Scent's effect increases (x2,x3) at Stages (4,5).","<c=ff2800>4</c>,<c=ff00ff>5</c> "),
    PBFieldNote.new(33,"Ingrain's effect <icon=fieldUp> . . .","Ingrain's effect increases (x2,x4) at Stages (2,4).","<c=ffb347>2</c>,<c=ff2800>4</c> "),
    PBFieldNote.new(33,"Certain attacks <icon=fieldUp> . . .","Fleur Cannon, Petal Blizzard and Petal Dance increase (x1.2,x1.5) at Stages (3,4).","<c=ec5800>3</c>,<c=ff2800>4</c> "),
    PBFieldNote.new(33,"Infestation damage <icon=fieldUp> . . .","Infestation deals (1/6,1/4,1/3) Max HP Damage per turn at Stages (3,4,5).","<c=ec5800>3</c>-<c=ff00ff>5</c> "),
    PBFieldNote.new(33,"Floral Healing recovery <icon=fieldChange> <c=green>100 %</c> ","","<c=ec5800>3</c>+"),
    PBFieldNote.new(33,"Acid Downpour resets to <c=orange>Stage 1</c> "),
    PBFieldNote.new(33,"Nature Power <icon=fieldChange> Growth","","<c=7CFC00>1</c>-<c=ff2800>4</c> "),
    PBFieldNote.new(33,"Nature Power <icon=fieldChange> Petal Blizzard","","<c=ff00ff>5</c> "),
    PBFieldNote.new(33,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::FLOWERGARDENF, :MIMICRY))}> "),
    PBFieldNote.new(33,"Secret Power <icon=fieldChange> <c=red>lowers</c> stats . . .", "Secret Power may lower Evasion. At Stage 3 and later additionally lowers Defense and Sp.Def. At Stage 5 this effect increases x2.","<c=7CFC00>1</c> <c=ec5800>3</c> <c=ff00ff>5</c> "),
    PBFieldNote.new(33,"Activates <c=orange>Synthetic Seed</c> . . .","Boosts Sp.Def and applies Ingrain to the user."),
  #Starlight Arena
    PBFieldNote.new(34,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::STARLIGHTA, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(34,"<c=red>Destroyed</c> when . . .","...when Light That Burns The Sky is used."),
    PBFieldNote.new(34,"Weather <c=red>stops</c> boosts . . .","...when weather is up, the field power boosts to moves and types isn't applied"),
    PBFieldNote.new(34,"<icon=fieldPsychic> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(34,"<icon=fieldFairy> attacks <icon=fieldUp> <c=green>x1.3</c> "),
    PBFieldNote.new(34,"<icon=fieldDark> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(34,"<icon=fieldDark> attacks <icon=fieldPlus> <icon=fieldFairy> "),
    PBFieldNote.new(34,"Victory Star <icon=fieldPlus> <c=green>boosts</c> damage"),
    PBFieldNote.new(34,"Geomancy <icon=fieldChange> <c=green>no charge turn</c> "),
    PBFieldNote.new(34,"<c=green>Activates</c> Marvel Scale"),
    PBFieldNote.new(34,"Illuminate <icon=fieldPlus> <c=green>boosts</c> stats . . .","Illuminate boosts Sp.Atk upon switching in."),
    PBFieldNote.new(34,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::STARLIGHTA, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(34,"Certain attacks <icon=fieldUp> <c=green>x2</c> . . . ",feToStringName(PBFields::STARLIGHTA, :MOVEDAMAGEBOOST, 2.0)),
    PBFieldNote.new(34,"Doom Desire <icon=fieldUp> <c=green>x4</c> and <icon=fieldPlus> <icon=fieldFire> "),
    PBFieldNote.new(34,"Certain attacks <icon=fieldChange> <icon=fieldFairy> . . .","Solar Beam, Solar Blade"),
    PBFieldNote.new(34,"Certain stat moves' effect <icon=fieldUp> . . .","Cosmic Power, Flash"),
    PBFieldNote.new(34,"Wish recovery <icon=fieldChange> <c=green>75 % HP</c> "),
    PBFieldNote.new(34,"Certain attacks <icon=fieldPlus> <c=green>boost</c> stats","Healing Wish and Lunar Dance boost recipient's Attack and Special Attack"),
    PBFieldNote.new(34,"Moonlight recovery <icon=fieldChange> <c=green>75 % HP</c> "),
    PBFieldNote.new(34,"<c=green>Enables</c> Aurora Veil"),
    PBFieldNote.new(34,"Shadow Shield <c=green>reduces</c> damage","Shadow Shield reduces damage of super effective hits by 0.75"),
    PBFieldNote.new(34,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::STARLIGHTA, :NATUREMOVES)}"),
    PBFieldNote.new(34,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::STARLIGHTA, :MIMICRY))}> "),
    PBFieldNote.new(34,"Secret Power <icon=fieldChange> <c=red>lowers</c> Sp.Def"),
    PBFieldNote.new(34,"Activates <c=orange>Magical Seed</c> . . .","Boosts Sp.Atk and applies Wish to the user."),
  #New World
    PBFieldNote.new(35,"<c=orange>\"From darkness, from stardust . . .</c> ", "From darkness, from stardust, from memories of eons past and visions yet to come..."),
    PBFieldNote.new(35,"Certain abilities change type . . .", "Multitype and RKS System randomly select a new type each turn."),
    PBFieldNote.new(35,"Speed <icon=fieldDown> <c=red>x0.75</c> when grounded"),
    PBFieldNote.new(35,"Airborne Pokémon defenses <icon=fieldDown> <c=red>x0.9</c>"),
    PBFieldNote.new(35,"<c=red>Prevents</c> all generated weather"),
    PBFieldNote.new(35,"<c=red>Prevents</c> generated Fields"),
    PBFieldNote.new(35,"<icon=fieldDark> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(35,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::NEWW, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(35,"Certain attacks <icon=fieldUp> <c=green>x2</c> . . . ",feToStringName(PBFields::NEWW, :MOVEDAMAGEBOOST, 2.0)),
    PBFieldNote.new(35,"Certain attacks <icon=fieldDown> <c=red>x0.25</c> . . . ",feToStringName(PBFields::NEWW, :MOVEDAMAGEBOOST, 0.25)),
    PBFieldNote.new(35,"Fissure <c=red>fails</c> "),
    PBFieldNote.new(35,"Doom Desire <icon=fieldUp> <c=green>x4</c> and <icon=fieldPlus> <icon=fieldFire> "),
    PBFieldNote.new(35,"Heart Swap <icon=fieldPlus> Pain Split effect"),
    PBFieldNote.new(35,"Victory Star damage <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(35,"Dark Void's Accuracy <icon=fieldChange> <c=green>85</c> "),
    PBFieldNote.new(35,"Lunar Dance <icon=fieldPlus> <c=green>boosts</c> all stats"),
    PBFieldNote.new(35,"Certain moves last <c=green>8</c> turns . . .","Trick Room, Magic Room, Wonder Room"),
    PBFieldNote.new(35,"Certain stat moves' effect <icon=fieldUp> . . .","Cosmic Power, Flash"),
    PBFieldNote.new(35,"Moonlight recovery <icon=fieldChange> <c=green>75 % HP</c> "),
    PBFieldNote.new(35,"Becomes a <c=orange>Starlight Arena</c> when . . .","...when Geomancy is used, or when Gravity is used for as long as Gravity lasts."),
    PBFieldNote.new(35,"Nature's Madness damage <icon=fieldChange> <c=green>75 % HP</c> "),
    PBFieldNote.new(35,"Shadow Shield <c=green>reduces</c> damage","Shadow Shield reduces damage of super effective hits by 0.75"),
    PBFieldNote.new(35,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::NEWW, :NATUREMOVES)}"),
    PBFieldNote.new(35,"Camouflage <icon=fieldChange> random type "),
    PBFieldNote.new(35,"Secret Power <icon=fieldChange> <c=red>lowers</c> all stats"),
    PBFieldNote.new(35,"Activates <c=orange>Magical Seed</c> . . .","Boosts all stats, but makes the user recharge."),
  #Inverse Field
    PBFieldNote.new(36,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::INVERSEF, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(36,"The type chart is <c=orange> inverted</c> "),
    PBFieldNote.new(36,"<c=green>Created</c> by Topsy Turvy when . . .","...Created (3 turns) when the attacker does not hold an Everstone."),
    PBFieldNote.new(36,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::INVERSEF, :NATUREMOVES)}"),
    PBFieldNote.new(36,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::INVERSEF, :MIMICRY))}> "),
    PBFieldNote.new(36,"Secret Power <icon=fieldChange> may confuse"),
    PBFieldNote.new(36,"Activates <c=orange>Magical Seed</c> . . .","Boosts all stats, but makes the user recharge."),
  #Psychic Field
    PBFieldNote.new(37,"<c=orange>\"#{FIELDEFFECTS.dig(PBFields::PSYCHICT, :INTROMESSAGE)}\"</c> "),
    PBFieldNote.new(37,"Priority attacks <c=red>fail</c> when . . .","...when used on grounded targets."),
    PBFieldNote.new(37,"<c=green>Created</c> when . . .","...when one of these effects is activated: Psychic Surge, Psychic Terrain, Genesis Supernova (5 turns)"),
    PBFieldNote.new(37,"<icon=fieldPsychic> attacks <icon=fieldUp> <c=green>x1.5</c> when . . .","...when attacker is grounded."),
    PBFieldNote.new(37,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(PBFields::PSYCHICT, :MOVEDAMAGEBOOST, 1.5)),
    PBFieldNote.new(37,"Pure Power boost <icon=fieldChange> Sp.Atk"),
    PBFieldNote.new(37,"Anticipation <c=green>boosts</c> Sp.Atk"),
    PBFieldNote.new(37,"Telepathy <c=green>boosts</c> Speed <c=green>x2</c> "),
    PBFieldNote.new(37,"Certain stat moves' effect <icon=fieldUp> . . .","Calm Mind, Cosmic Power, Kinesis, Meditate, Nasty Plot"),
    PBFieldNote.new(37,"Certain attacks <icon=fieldPlus> <c=green>boost</c> Sp.Atk . . .","Mind Reader, Miracle Eye, Psych Up boost Sp.Atk two stages"),
    PBFieldNote.new(37,"Hypnosis accuracy <icon=fieldChange> <c=green>90</c> "),
    PBFieldNote.new(37,"Kinesis <icon=fieldPlus> <icon=fieldUp> Attack/Sp.Atk"),
    PBFieldNote.new(37,"Telekinesis <icon=fieldPlus> <icon=fieldDown> . . .", "... drops opponents' Defense/Sp.Def by two stages"),
    PBFieldNote.new(37,"Certain moves' effect <icon=fieldChange> <c=green>8</c> turns","Gravity, Magic Room, Trick Room, Wonder Room"),
    PBFieldNote.new(37,"Shattered Psyche <icon=fieldPlus> confuses"),
    PBFieldNote.new(37,"Nature Power <icon=fieldChange> #{feToStringName(PBFields::PSYCHICT, :NATUREMOVES)}"),
    PBFieldNote.new(37,"Camouflage <icon=fieldChange> <icon=field#{PBTypes.getName(FIELDEFFECTS.dig(PBFields::PSYCHICT, :MIMICRY))}> "),
    PBFieldNote.new(37,"Secret Power <icon=fieldChange> may confuse"),
    PBFieldNote.new(37,"Activates <c=orange>Magical Seed</c> . . .","Boosts Sp.Atk by two stages, but confuses the user.")

  ]

  File.open("Data/fieldnotes.dat","wb"){|file|
    Marshal.dump(all_field_notes,file)
  }
end
